/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy.wires;

import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.util.IELogger;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WireType {
    public static final String LV_CATEGORY = "LV";
    public static final String MV_CATEGORY = "MV";
    public static final String HV_CATEGORY = "HV";
    public static final String STRUCTURE_CATEGORY = "STRUCTURE";
    public static final String REDSTONE_CATEGORY = "REDSTONE";
    private static LinkedHashSet<WireType> values = new LinkedHashSet();
    public static String[] uniqueNames = new String[]{"COPPER", "ELECTRUM", "STEEL", "STRUCTURE_ROPE", "STRUCTURE_STEEL", "REDSTONE", "COPPER_INS", "ELECTRUM_INS"};
    public static double[] wireLossRatio;
    public static int[] wireTransferRate;
    public static int[] wireColouration;
    public static int[] wireLength;
    public static Item ieWireCoil;
    public static double[] renderDiameter;
    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite iconDefaultWire;
    public static WireType COPPER;
    public static WireType ELECTRUM;
    public static WireType STEEL;
    public static WireType STRUCTURE_ROPE;
    public static WireType STRUCTURE_STEEL;
    public static WireType REDSTONE;
    public static WireType COPPER_INSULATED;
    public static WireType ELECTRUM_INSULATED;

    public static LinkedHashSet<WireType> getValues() {
        return values;
    }

    public static WireType getValue(String name) {
        for (WireType type : values) {
            if (type == null || !type.getUniqueName().equals(name)) continue;
            return type;
        }
        return COPPER;
    }

    public WireType() {
        values.add(this);
    }

    public abstract String getUniqueName();

    public abstract double getLossRatio();

    public abstract int getTransferRate();

    public abstract int getColour(ImmersiveNetHandler.Connection var1);

    public abstract double getSlack();

    @SideOnly(value=Side.CLIENT)
    public abstract TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection var1);

    public abstract int getMaxLength();

    public abstract ItemStack getWireCoil();

    public ItemStack getWireCoil(ImmersiveNetHandler.Connection c) {
        return this.getWireCoil();
    }

    public abstract double getRenderDiameter();

    public abstract boolean isEnergyWire();

    public boolean canCauseDamage() {
        return false;
    }

    @Nullable
    public String getCategory() {
        return null;
    }

    public double getDamageRadius() {
        return 0.0;
    }

    public static void init() {
        ModContainer currentMod = Loader.instance().activeModContainer();
        if (currentMod != null && !"immersiveengineering".equals(currentMod.getModId())) {
            IELogger.error("WireType#init was called by " + currentMod.getName() + " (" + currentMod.getModId() + ")!");
            IELogger.error("The method should only be called by Immersive Engineering, calls from other mods will cause many hard-to-debug issues and are therefore forbidden!");
            IELogger.error("Please report this as a bug to " + currentMod.getName());
            return;
        }
        COPPER = new IEBASE(0);
        ELECTRUM = new IEBASE(1);
        STEEL = new IEBASE(2);
        STRUCTURE_ROPE = new IEBASE(3);
        STRUCTURE_STEEL = new IEBASE(4);
        REDSTONE = new IEBASE(5);
        COPPER_INSULATED = new IEBASE(6);
        ELECTRUM_INSULATED = new IEBASE(7);
        WireApi.registerFeedthroughForWiretype(COPPER, new ResourceLocation("immersiveengineering", "block/connector/connector_lv.obj"), new ResourceLocation("immersiveengineering", "blocks/connector_connector_lv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.5, IEContent.blockConnectors.func_176203_a(BlockTypes_Connector.CONNECTOR_LV.getMeta()), 16.0f / (float)COPPER.getTransferRate(), 2.0f, f -> f);
        WireApi.registerFeedthroughForWiretype(ELECTRUM, new ResourceLocation("immersiveengineering", "block/connector/connector_mv.obj"), new ResourceLocation("immersiveengineering", "blocks/connector_connector_mv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.5625, IEContent.blockConnectors.func_176203_a(BlockTypes_Connector.CONNECTOR_MV.getMeta()), 40.0f / (float)ELECTRUM.getTransferRate(), 5.0f, f -> f);
        WireApi.registerFeedthroughForWiretype(STEEL, new ResourceLocation("immersiveengineering", "block/connector/connector_hv.obj"), new ResourceLocation("immersiveengineering", "blocks/connector_connector_hv"), new float[]{0.0f, 4.0f, 8.0f, 12.0f}, 0.75, IEContent.blockConnectors.func_176203_a(BlockTypes_Connector.CONNECTOR_HV.getMeta()), 120.0f / (float)STEEL.getTransferRate(), 15.0f, f -> f);
        WireApi.registerFeedthroughForWiretype(REDSTONE, new ResourceLocation("immersiveengineering", "block/connector/connector_redstone.obj.ie"), (ImmutableMap<String, String>)ImmutableMap.of(), new ResourceLocation("immersiveengineering", "blocks/connector_connector_redstone"), new float[]{3.0f, 8.0f, 11.0f, 16.0f}, 0.5625, 0.5, IEContent.blockConnectors.func_176203_a(BlockTypes_Connector.CONNECTOR_REDSTONE.getMeta()), 0.0f, 0.0f, f -> f);
    }

    public IElectricEquipment.ElectricSource getElectricSource() {
        return COPPER.getElectricSource();
    }

    static {
        renderDiameter = new double[]{0.03125, 0.03125, 0.0625, 0.0625, 0.0625, 0.03125};
    }

    private static class IEBASE
    extends WireType {
        final int ordinal;
        private final IElectricEquipment.ElectricSource eSource;

        public IEBASE(int ordinal) {
            this.ordinal = ordinal;
            WireApi.registerWireType(this);
            this.eSource = this.canCauseDamage() ? new IElectricEquipment.ElectricSource(0.5f * (float)(1 + ordinal)) : new IElectricEquipment.ElectricSource(-1.0f);
        }

        @Override
        public double getLossRatio() {
            return Math.abs(wireLossRatio[this.ordinal % 6]);
        }

        @Override
        public int getTransferRate() {
            return Math.abs(wireTransferRate[this.ordinal % 6]);
        }

        @Override
        public int getColour(ImmersiveNetHandler.Connection connection) {
            return wireColouration[this.ordinal];
        }

        @Override
        public double getSlack() {
            return 1.005;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getIcon(ImmersiveNetHandler.Connection connection) {
            return iconDefaultWire;
        }

        @Override
        public int getMaxLength() {
            return wireLength[this.ordinal % 6];
        }

        @Override
        public ItemStack getWireCoil() {
            return new ItemStack(ieWireCoil, 1, this.ordinal);
        }

        @Override
        public String getUniqueName() {
            return uniqueNames[this.ordinal];
        }

        @Override
        public double getRenderDiameter() {
            return renderDiameter[this.ordinal % 6];
        }

        @Override
        public boolean isEnergyWire() {
            return this.ordinal % 6 < 3;
        }

        @Override
        public double getDamageRadius() {
            switch (this.ordinal) {
                case 0: {
                    return 0.05;
                }
                case 1: {
                    return 0.1;
                }
                case 2: {
                    return 0.3;
                }
            }
            return 0.0;
        }

        @Override
        public boolean canCauseDamage() {
            return this.ordinal < 3;
        }

        @Override
        @Nullable
        public String getCategory() {
            switch (this.ordinal) {
                case 0: 
                case 6: {
                    return WireType.LV_CATEGORY;
                }
                case 1: 
                case 7: {
                    return WireType.MV_CATEGORY;
                }
                case 2: {
                    return WireType.HV_CATEGORY;
                }
                case 3: 
                case 4: {
                    return WireType.STRUCTURE_CATEGORY;
                }
                case 5: {
                    return WireType.REDSTONE_CATEGORY;
                }
            }
            return null;
        }

        @Override
        public IElectricEquipment.ElectricSource getElectricSource() {
            return this.eSource;
        }
    }
}

