/*
 * Decompiled with CFR 0.152.
 */
package ic2.fsIntigration.core;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import ic2.core.block.resources.BlockRubberWood;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.util.math.IntCounter;
import ic2.fsIntigration.core.CropRubber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IC2RubberFarmLogic
implements IFarmLogic {
    NonNullList<ItemStack> list = NonNullList.func_191196_a();
    private final Map<BlockPos, IntCounter> lastExtents = new HashMap<BlockPos, IntCounter>();

    public int getFertilizerConsumption() {
        return 40;
    }

    public int getWaterConsumption(float hydrationModifier) {
        return (int)(hydrationModifier * 5.0f);
    }

    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        NonNullList<ItemStack> result = this.list;
        this.list = NonNullList.func_191196_a();
        return result;
    }

    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        ArrayList<ICrop> list = new ArrayList<ICrop>();
        for (int i = 0; i < extent; ++i) {
            list.addAll(this.getCrops(world, pos.func_177967_a(direction.getFacing(), i)));
        }
        return list;
    }

    private List<ICrop> getCrops(World world, BlockPos pos) {
        BlockPos position;
        IBlockState state;
        ArrayList<ICrop> crop = new ArrayList<ICrop>();
        for (int i = 0; i < 10 && (state = world.func_180495_p(position = pos.func_177981_b(i))).func_177230_c() != Blocks.field_150350_a; ++i) {
            if (state.func_177230_c() != Ic2States.rubberWood.func_177230_c() || !((Boolean)state.func_177229_b((IProperty)BlockRubberWood.collectable)).booleanValue()) continue;
            crop.add(new CropRubber(world, position));
        }
        return crop;
    }

    public IFarmLogic setManual(boolean manual) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureMap() {
        return TextureMap.field_110575_b;
    }

    public String getName() {
        return "Rubber Plantation";
    }

    public ItemStack getIconItemStack() {
        return Ic2Items.stickyResin.func_77946_l();
    }
}

