/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.events;

import ic2.api.classic.tile.ITeleporterTarget;
import ic2.core.IC2;
import ic2.core.energy.EnergyNetGlobal;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.player.TeamManager;
import ic2.core.platform.registry.Ic2People;
import ic2.core.util.helpers.ChunkUpdater;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.FoodStats;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TickEventHandler {
    @SubscribeEvent
    public void onWorldTickEvent(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            this.onWorldTickEnd(evt.world);
            this.onCommonWorldTickEnd(evt.world);
        } else if (evt.phase == TickEvent.Phase.START) {
            this.onWorldTickStart(evt.world);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            this.onServerTickEnd();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world == null) {
            return;
        }
        EnergyNetGlobal.onWorldUnload(world);
        IC2.windManager.onWorldUnload(world);
        IC2.callbacks.onWorldUnload(world);
        IC2.network.get().onWorldUnload(world);
        ChunkUpdater.onWorldUnloaded(world);
        Map<ITeleporterTarget.TeleporterTarget, String> mapData = ITeleporterTarget.TeleporterNameRegistry.getMap();
        Iterator<Map.Entry<ITeleporterTarget.TeleporterTarget, String>> iter = mapData.entrySet().iterator();
        int dim = world.field_73011_w.getDimension();
        while (iter.hasNext()) {
            ITeleporterTarget.TeleporterTarget target = iter.next().getKey();
            if (target.getDimID() != dim) continue;
            iter.remove();
        }
    }

    @SubscribeEvent
    public void onChunkUnloaded(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        if (chunk == null) {
            return;
        }
        ChunkUpdater.onChunkUnload(chunk);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                this.onCommonWorldTickEnd((World)mc.field_71441_e);
            }
            IC2.keyboard.sendKeyUpdate();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || evt.player == null) {
            return;
        }
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(evt.player);
        EntityPlayer player = handler.getPlayer();
        if (evt.side == Side.SERVER && player != null) {
            FoodStats food;
            if (handler.watching != null) {
                IC2.network.get(true).updateGuiChanges(player, handler.watching);
            } else if (handler.wailaWatching != null) {
                IC2.network.get(true).updateGuiChanges(player, handler.wailaWatching);
            }
            if (player.field_70170_p.func_82737_E() % 200L == 0L && Ic2People.minesasha.equals(player.func_110124_au()) && (food = player.func_71024_bL()).func_75116_a() < 10) {
                food.func_75114_a(12);
            }
        }
    }

    private void onServerTickEnd() {
        IC2.callbacks.onServerTick();
        IC2.network.get(true).clearGuiFields();
        TeamManager.instance.onUpdate();
    }

    private void onCommonWorldTickEnd(World world) {
        IC2.callbacks.onWorldTick(world);
    }

    private void onWorldTickEnd(World world) {
        IC2.network.get().onTick(world);
        EnergyNetGlobal.onTickEnd(world);
        IC2.windManager.getHanlderFromWorld(world).onTick();
    }

    private void onWorldTickStart(World world) {
        EnergyNetGlobal.onTickStart(world);
    }
}

