/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import ic2.core.IC2;
import ic2.core.platform.textures.Sprites;
import ic2.core.platform.textures.SubIconManager;
import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SubIcon
extends TextureAtlasSprite {
    public String sheetName;
    public int pos;
    public int modify = -1;
    public Sprites.SpriteInfo info;

    public SubIcon(String name, String sheet, int pos, Sprites.SpriteInfo info, int modify) {
        super(name);
        this.sheetName = sheet;
        this.pos = pos;
        this.info = info;
        this.modify = modify;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        int xCoord = 0;
        int yCoord = 0;
        try {
            BufferedImage sheet = SubIconManager.sheetCache.get(this.sheetName);
            if (sheet == null) {
                sheet = SubIconManager.loadSheet(manager, this.sheetName);
                SubIconManager.sheetCache.put(this.sheetName, sheet);
            }
            this.field_130223_c = sheet.getWidth() / this.info.maxX;
            this.field_130224_d = sheet.getHeight() / this.info.maxY;
            int x = this.pos % this.info.maxX * this.field_130223_c;
            int y = this.pos / this.info.maxX * this.field_130224_d;
            xCoord = x;
            yCoord = y;
            if (this.modify != -1) {
                this.field_130223_c *= this.modify;
                this.field_130224_d *= this.modify;
            }
            int[] data = new int[this.field_130223_c * this.field_130224_d];
            sheet.getRGB(x, y, this.field_130223_c, this.field_130224_d, data, 0, this.field_130223_c);
            int[][] mipmaps = new int[FMLClientHandler.instance().getClient().field_71474_y.field_151442_I + 1][];
            mipmaps[0] = data;
            this.field_110976_a.add(mipmaps);
            return false;
        }
        catch (Exception e) {
            IC2.log.info("IconCrash: " + this.field_130223_c + ":" + this.field_130224_d + ":" + xCoord + ":" + yCoord);
            e.printStackTrace();
            IC2.platform.displayError("Icon Loader Crashed at Icon: " + this.sheetName + " X: " + xCoord + " Y: " + yCoord);
            return true;
        }
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        try {
            return manager.func_110536_a(location) == null;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

