/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.player;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ic2.core.platform.player.achievements.IC2Stat;
import ic2.core.platform.player.achievements.PercentFormatter;
import ic2.core.platform.player.achievements.criteria.KilledWithItemTrigger;
import ic2.core.platform.player.achievements.criteria.StatTrigger;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ItemWithMeta;
import ic2.core.util.misc.StackUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.FrameType;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.IStatType;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class IC2Advancements {
    public static KilledWithItemTrigger PLAYER_KILLS;
    public static StatTrigger STAT_CHANGE;
    Map<String, IC2Stat> statMap = new HashMap<String, IC2Stat>();
    private int achievementBaseX = -4;
    private int achievementBaseY = -5;

    public void init() {
        PLAYER_KILLS = new KilledWithItemTrigger();
        STAT_CHANGE = new StatTrigger();
        Map registry = (Map)ReflectionHelper.getPrivateValue(CriteriaTriggers.class, null, (int)0);
        registry.put(PLAYER_KILLS.func_192163_a(), PLAYER_KILLS);
        registry.put(STAT_CHANGE.func_192163_a(), STAT_CHANGE);
        this.registerStat("luckyPerson", StatBase.field_75980_h, false);
        this.registerStat("sinns", StatBase.field_75980_h, false);
        this.registerStat("cropBreeder", StatBase.field_75980_h, false);
        this.registerStat("scaffolded", StatBase.field_75980_h, false, true);
        this.registerStat("cultivateEnd", StatBase.field_75980_h, false, true);
        this.registerStat("teleportFarAway", StatBase.field_75980_h, false);
        this.registerStat("diedFromNuke", StatBase.field_75980_h, false);
        this.registerStat("nukesSurvived", StatBase.field_75980_h, false);
        this.registerStat("drownWithQHelmet", StatBase.field_75980_h, false);
        this.registerStat("starveWithQHelmet", StatBase.field_75980_h, false);
        this.registerStat("cableShockDamage", StatBase.field_75980_h, false);
        this.registerStat("nuclearJetpacksExploded", StatBase.field_75980_h, false);
        this.registerStat("nuclearReactorsExploded", StatBase.field_75980_h, false);
        this.registerStat("steamReactorsExploded", StatBase.field_75980_h, false);
        this.registerStat("nukesIgnited", StatBase.field_75980_h, false);
        this.registerStat("nanoArmorDamageTaken", StatBase.field_75980_h, false);
        this.registerStat("quantumArmorDamageTaken", StatBase.field_75980_h, false);
        this.registerStat("dragonsLasered", StatBase.field_75980_h, false);
        this.registerStat("killCreeperChainsaw", StatBase.field_75980_h, false);
        this.registerStat("nukedWither", StatBase.field_75980_h, false);
        this.registerStat("chainsawKills", StatBase.field_75980_h, false);
        this.registerStat("laserKills", StatBase.field_75980_h, false);
        this.registerStat("jetpacktimeflown", StatBase.field_75981_i, false);
        this.registerStat("rocketModesUsed", StatBase.field_75980_h, false);
        this.registerStat("blocksDrilled", StatBase.field_75980_h, false);
        this.registerStat("blocksSawed", StatBase.field_75980_h, false);
        this.registerStat("blocksLasered", StatBase.field_75980_h, false);
        this.registerStat("distanceTeleported", StatBase.field_75979_j, false);
        this.registerStat("foamSprayed", StatBase.field_75980_h, false);
        this.registerStat("playersDisliked", StatBase.field_75980_h, true);
        this.registerStat("beersBrewed", StatBase.field_75980_h, false);
        this.registerStat("lightDrunk", StatBase.field_75980_h, false);
        this.registerStat("medDrunk", StatBase.field_75980_h, false);
        this.registerStat("badDrunk", StatBase.field_75980_h, false);
        this.registerStat("deadlyDrunk", StatBase.field_75980_h, false);
        this.registerStat("foodcanEaten", StatBase.field_75980_h, false);
        this.registerStat("airCellsUsed", StatBase.field_75980_h, false);
        this.registerStat("overgrowthFertilierUsed", StatBase.field_75980_h, false);
        this.registerStat("restoringFertilizerUsed", StatBase.field_75980_h, false);
        this.registerStat("electricItemsEnchanted", StatBase.field_75980_h, false);
        this.registerStat("texturesStolen", StatBase.field_75980_h, false);
        this.registerStat("cleanEnergy", new PercentFormatter("ic2:dirtyEnergy"), false);
        this.registerStat("dirtyEnergy", new PercentFormatter("ic2:cleanEnergy"), false);
        this.registerStat("teaLover", new PercentFormatter("ic2:coffeeLover"), false);
        this.registerStat("coffeeLover", new PercentFormatter("ic2:teaLover"), false);
        this.registerStat("machineSaver", new PercentFormatter("ic2:machineLoser"), false);
        this.registerStat("machineLoser", new PercentFormatter("ic2:machineSaver"), false);
        this.registerStat("itemEnergyUsed", StatBase.field_75980_h, false);
        this.registerStat("itemSmelted", StatBase.field_75980_h, false);
        this.registerStat("itemAutoSmelted", StatBase.field_75980_h, false);
        this.registerStat("itemMacerated", StatBase.field_75980_h, false);
        this.registerStat("itemAutoMacerated", StatBase.field_75980_h, false);
        this.registerStat("itemExtracted", StatBase.field_75980_h, false);
        this.registerStat("itemAutoExtracted", StatBase.field_75980_h, false);
        this.registerStat("itemCompressed", StatBase.field_75980_h, false);
        this.registerStat("itemAutoCompressed", StatBase.field_75980_h, false);
        this.registerStat("itemRecycled", StatBase.field_75980_h, false);
        this.registerStat("itemAutoRecycled", StatBase.field_75980_h, false);
        this.registerStat("uuMatterProduced", StatBase.field_75980_h, false);
        this.registerAchievement("acquireResin", 2, 0, Ic2Items.stickyResin.func_77946_l(), "root", false, IC2Advancements.makeStackRequirement(Ic2Items.stickyResin.func_77946_l()));
        this.registerAchievement("acquireRefinedIron", 0, 0, Ic2Items.refinedIronIngot.func_77946_l(), "root", false, IC2Advancements.makeStackRequirement(Ic2Items.refinedIronIngot.func_77946_l()));
        this.registerAchievement("buildCable", 0, 2, Ic2Items.insulatedCopperCable.func_77946_l(), "acquireRefinedIron", false, IC2Advancements.makeStackRequirement(Ic2Items.insulatedCopperCable.func_77946_l()));
        this.registerAchievement("buildEUReader", -2, 4, Ic2Items.euReader.func_77946_l(), "buildCable", false, IC2Advancements.makeStackRequirement(Ic2Items.euReader.func_77946_l()));
        this.registerAchievement("buildMachineTool", -2, 6, Ic2Items.machineTool.func_77946_l(), "buildEUReader", false, IC2Advancements.makeStackRequirement(Ic2Items.machineTool.func_77946_l()));
        this.registerAchievement("buildGenerator", 6, 4, Ic2Items.generator.func_77946_l(), "buildCable", false, IC2Advancements.makeStackRequirement(Ic2Items.generator.func_77946_l()));
        this.registerAchievement("buildMacerator", 6, 0, Ic2Items.macerator.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.macerator.func_77946_l()));
        this.registerAchievement("buildCoalDiamond", 8, -2, Ic2Items.industrialDiamond.func_77946_l(), "buildMacerator", false, IC2Advancements.makeStackRequirement(Ic2Items.industrialDiamond.func_77946_l()));
        this.registerAchievement("buildRotMacerator", 8, 0, Ic2Items.rotaryMacerator.func_77946_l(), "buildMacerator", false, IC2Advancements.makeStackRequirement(Ic2Items.rotaryMacerator.func_77946_l()));
        this.registerAchievement("buildCanner", 8, 2, Ic2Items.canner.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.canner.func_77946_l()));
        this.registerAchievement("buildVacCanner", 10, 2, Ic2Items.vacuumCanner.func_77946_l(), "buildCanner", false, IC2Advancements.makeStackRequirement(Ic2Items.vacuumCanner.func_77946_l()));
        this.registerAchievement("buildElecFurnace", 8, 4, Ic2Items.electroFurnace.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.electroFurnace.func_77946_l()));
        this.registerAchievement("buildIndFurnace", 10, 4, Ic2Items.inductionFurnace.func_77946_l(), "buildElecFurnace", false, IC2Advancements.makeStackRequirement(Ic2Items.inductionFurnace.func_77946_l()));
        this.registerAchievement("buildCompressor", 4, 8, Ic2Items.compressor.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.compressor.func_77946_l()));
        this.registerAchievement("buildSingCompressor", 2, 7, Ic2Items.singularityCompressor.func_77946_l(), "buildCompressor", false, IC2Advancements.makeStackRequirement(Ic2Items.singularityCompressor.func_77946_l()));
        this.registerAchievement("compressUranium", 2, 8, Ic2Items.uraniumIngot.func_77946_l(), "buildCompressor", false, IC2Advancements.makeStackRequirement(Ic2Items.uraniumIngot.func_77946_l()));
        this.registerAchievement("dieFromOwnNuke", 0, 8, Ic2Items.nuke.func_77946_l(), "compressUranium", true, IC2Advancements.makeStatRequirement(this.getStat("diedFromNuke"), 1));
        this.registerAchievement("buildRecycler", 4, 6, Ic2Items.recycler.func_77946_l(), "buildCompressor", false, IC2Advancements.makeStackRequirement(Ic2Items.recycler.func_77946_l()));
        this.registerAchievement("buildCompRecycler", 2, 6, Ic2Items.compactingRecycler.func_77946_l(), "buildRecycler", false, IC2Advancements.makeStackRequirement(Ic2Items.compactingRecycler.func_77946_l()));
        this.registerAchievement("buildExtractor", 8, 6, Ic2Items.extractor.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.extractor.func_77946_l()));
        this.registerAchievement("buildCentExtractor", 10, 6, Ic2Items.centrifugalExtractor.func_77946_l(), "buildExtractor", false, IC2Advancements.makeStackRequirement(Ic2Items.centrifugalExtractor.func_77946_l()));
        this.registerAchievement("buildBatBox", 6, 10, Ic2Items.batBox.func_77946_l(), "buildGenerator", false, IC2Advancements.makeStackRequirement(Ic2Items.batBox.func_77946_l()));
        this.registerAchievement("buildDrill", 8, 10, Ic2Items.electricDrill.func_77946_l(), "buildBatBox", false, IC2Advancements.makeStackRequirement(Ic2Items.electricDrill.func_77946_l()));
        this.registerAchievement("buildDDrill", 10, 10, Ic2Items.diamondDrill, "buildDrill", false, IC2Advancements.makeStackRequirement(Ic2Items.diamondDrill.func_77946_l()));
        this.registerAchievement("buildChainsaw", 4, 10, Ic2Items.chainSaw.func_77946_l(), "buildBatBox", false, IC2Advancements.makeStackRequirement(Ic2Items.chainSaw.func_77946_l()));
        this.registerAchievement("killCreeperChainsaw", 2, 10, Ic2Items.chainSaw.func_77946_l(), "buildChainsaw", true, IC2Advancements.makeStatRequirement(this.getStat("killCreeperChainsaw"), 1));
        this.registerAchievement("buildMFE", 6, 12, Ic2Items.mfe.func_77946_l(), "buildBatBox", false, IC2Advancements.makeStackRequirement(Ic2Items.mfe.func_77946_l()));
        this.registerAchievement("buildMassFab", 8, 12, Ic2Items.massfabricator.func_77946_l(), "buildBatBox", false, IC2Advancements.makeStackRequirement(Ic2Items.massfabricator.func_77946_l()));
        this.registerAchievement("acquireMatter", 10, 12, Ic2Items.uuMatter.func_77946_l(), "buildMassFab", false, IC2Advancements.makeStackRequirement(Ic2Items.uuMatter.func_77946_l()));
        this.registerAchievement("buildQArmor", 12, 12, Ic2Items.quantumChest.func_77946_l(), "acquireMatter", false, IC2Advancements.makeStackRequirement(Ic2Items.quantumChest.func_77946_l()));
        this.registerAchievement("buildMiningLaser", 4, 12, Ic2Items.miningLaser.func_77946_l(), "buildMFE", false, IC2Advancements.makeStackRequirement(Ic2Items.miningLaser.func_77946_l()));
        this.registerAchievement("killDragonMiningLaser", 2, 12, Ic2Items.miningLaser.func_77946_l(), "buildMiningLaser", true, IC2Advancements.makeStatRequirement(this.getStat("dragonsLasered"), 1));
        this.registerAchievement("buildMFS", 6, 14, Ic2Items.mfsu.func_77946_l(), "buildMFE", false, IC2Advancements.makeStackRequirement(Ic2Items.mfsu.func_77946_l()));
        this.registerAchievement("buildTeleporter", 4, 14, Ic2Items.teleporter.func_77946_l(), "buildMFS", false, IC2Advancements.makeStackRequirement(Ic2Items.teleporter.func_77946_l()));
        this.registerAchievement("teleportFarAway", 2, 14, Ic2Items.teleporter.func_77946_l(), "buildTeleporter", true, IC2Advancements.makeStatRequirement(this.getStat("teleportFarAway"), 1));
        this.registerAchievement("buildTerraformer", 8, 14, Ic2Items.terraformer.func_77946_l(), "buildMFS", false, IC2Advancements.makeStackRequirement(Ic2Items.terraformer.func_77946_l()));
        this.registerAchievement("terraformEndCultivation", 10, 14, Ic2Items.tfbpBiomeCultivation.func_77946_l(), "buildTerraformer", true, IC2Advancements.makeStatRequirement(this.getStat("cultivateEnd"), 1));
        this.registerAchievement("buildPESU", 6, 16, Ic2Items.pesu.func_77946_l(), "buildMFS", true, IC2Advancements.makeStackRequirement(Ic2Items.pesu.func_77946_l()));
        this.registerSteamAchievement("luckyBastard", 20, 0, Ic2Items.industrialDiamond.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("luckyPerson"), 100));
        this.registerSteamAchievement("Sinner", 20, 2, Ic2Items.reactorUraniumRodSingle.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("sinns"), 666));
        this.registerSteamAchievement("scaffolded", 20, 4, Ic2Items.ironScaffold.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("scaffolded"), 1));
        this.registerSteamAchievement("killWitherWithNuke", 20, 6, new ItemStack(Items.field_151144_bL, 1, 1), IC2Advancements.makeStatRequirement(this.getStat("nukedWither"), 1));
        this.registerSteamAchievement("cropBeginner", 18, 0, Ic2Items.cropStick.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("cropBreeder"), 10));
        this.registerSteamAchievement("cropChallenger", 18, 2, Ic2Items.cropSeed.func_77946_l(), "cropBeginner", IC2Advancements.makeStatRequirement(this.getStat("cropBreeder"), 100));
        this.registerSteamAchievement("cropExpert", 18, 4, Ic2Items.cropAnalyzer.func_77946_l(), "cropChallenger", IC2Advancements.makeStatRequirement(this.getStat("cropBreeder"), 1000));
        this.registerSteamAchievement("cropGrandMaster", 18, 6, Ic2Items.cropHarvester.func_77946_l(), "cropExpert", IC2Advancements.makeStatRequirement(this.getStat("cropBreeder"), 10000));
        this.registerSteamAchievement("cropBlank", 18, 8, Ic2Items.displayIcons[8].func_77946_l(), "cropGrandMaster", IC2Advancements.makeStatRequirement(this.getStat("cropBreeder"), 1000000));
        this.registerSteamAchievement("indestructable", 18, 8, Ic2Items.compositeChest.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("nukesSurvived"), 10));
        this.registerSteamAchievement("bitClean", 22, 0, Ic2Items.plantBall.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("cleanEnergy"), this.getStat("dirtyEnergy"), 100, 75));
        this.registerSteamAchievement("goGreen", 22, 2, new ItemStack((Block)Blocks.field_150328_O), "bitClean", IC2Advancements.makeStatRequirement(this.getStat("cleanEnergy"), this.getStat("dirtyEnergy"), 100, 90));
        this.registerSteamAchievement("goCoal", 24, 0, Ic2Items.generator.func_77946_l(), IC2Advancements.makeStatRequirement(this.getStat("dirtyEnergy"), this.getStat("cleanEnergy"), 100, 75));
        this.registerSteamAchievement("factoryGiant", 24, 2, Ic2Items.nuclearReactor.func_77946_l(), "goCoal", IC2Advancements.makeStatRequirement(this.getStat("dirtyEnergy"), this.getStat("cleanEnergy"), 100, 90));
    }

    public void registerStat(String id, IStatType formatter, boolean independet) {
        this.registerStat(id, formatter, independet, false);
    }

    public void registerStat(String id, IStatType formatter, boolean independet, boolean hidden) {
        IC2Stat base = new IC2Stat("ic2:" + id, (ITextComponent)new TextComponentTranslation("stat." + id + ".name", new Object[0]), formatter);
        if (hidden) {
            base.setHidden();
        }
        if (independet) {
            base.func_75966_h();
        }
        base.func_75971_g();
        this.statMap.put(id, base);
    }

    public void registerSteamAchievement(String id, int x, int y, ItemStack display, Consumer<JsonObject> req) {
        this.registerAchievement(id, x, y, display, "root", true, req);
    }

    public void registerSteamAchievement(String id, int x, int y, ItemStack display, String requirement, Consumer<JsonObject> req) {
        this.registerAchievement(id, x, y, display, requirement, true, req);
    }

    public void registerAchievement(String id, int x, int y, ItemStack display, String requirement, boolean special, Consumer<JsonObject> req) {
        this.registerAchievement(id, x, y, display, new ResourceLocation("ic2", "basic/" + requirement), special, req);
    }

    public void registerAchievement(String id, int x, int y, ItemStack display, ResourceLocation requirement, boolean special, Consumer<JsonObject> req) {
    }

    private JsonObject createDisplay(ItemStack item, String id, boolean special) {
        JsonObject display = new JsonObject();
        JsonObject icon = new JsonObject();
        icon.addProperty("item", item.func_77973_b().getRegistryName().toString());
        icon.addProperty("data", (Number)item.func_77960_j());
        display.add("icon", (JsonElement)icon);
        JsonObject title = new JsonObject();
        display.add("title", (JsonElement)title);
        title.addProperty("translate", "achievement." + id);
        JsonObject desc = new JsonObject();
        desc.addProperty("translate", "achievement." + id + ".desc");
        display.add("description", (JsonElement)desc);
        if (special) {
            display.addProperty("frame", FrameType.CHALLENGE.func_192307_a());
        }
        return display;
    }

    public void issueStat(EntityPlayer player, String id, int amount) {
        IC2Stat base = this.getStat(id);
        if (base != null) {
            base.addStat(player, amount);
        }
    }

    public void issueStat(EntityPlayer player, String id) {
        this.issueStat(player, id, 1);
    }

    public void clearStat(EntityPlayer player, String id) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        IC2Stat base = this.getStat(id);
        if (base != null) {
            StatisticsManagerServer server = ((EntityPlayerMP)player).func_147099_x();
            int amount = server.func_77444_a((StatBase)base);
            if (amount <= 0) {
                return;
            }
            server.func_150871_b(player, (StatBase)base, -amount);
        }
    }

    public IC2Stat getStat(String id) {
        return this.statMap.get(id);
    }

    public void onExtract(EntityPlayer player, ItemStack stack, boolean automated) {
        if (StackUtil.hasOreTag("itemRubber", stack)) {
            this.issueStat(player, "cleanEnergy", stack.func_190916_E());
        } else if (StackUtil.isStackEqual(stack, Ic2Items.coalFuelCell)) {
            this.issueStat(player, "dirtyEnergy", stack.func_190916_E());
        } else if (StackUtil.isStackEqual(stack, Ic2Items.bioFuelCell)) {
            this.issueStat(player, "cleanEnergy", stack.func_190916_E());
        }
    }

    public void onSmelting(EntityPlayer player, ItemStack stack, boolean automated) {
        if (!automated) {
            this.issueStat(player, "itemSmelted", stack.func_190916_E());
        }
        if (StackUtil.hasOreTag("itemRubber", stack)) {
            this.issueStat(player, "dirtyEnergy", stack.func_190916_E());
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack stack) {
        if (StackUtil.isStackEqual(stack, Ic2Items.reactorUraniumRodSingle)) {
            this.issueStat(player, "sinns");
        }
    }

    public static Consumer<JsonObject> makeStatRequirement(final StatBase id, final int require) {
        return new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                JsonObject criteria = new JsonObject();
                JsonObject hasStat = new JsonObject();
                hasStat.addProperty("trigger", new ResourceLocation("ic2", "has_stat").toString());
                JsonObject obj = new JsonObject();
                JsonObject stat = new JsonObject();
                stat.addProperty("type", "normal");
                stat.addProperty("stat", id.field_75975_e);
                stat.addProperty("amount", (Number)require);
                obj.add("stat", (JsonElement)stat);
                hasStat.add("conditions", (JsonElement)obj);
                criteria.add("has_stat", (JsonElement)hasStat);
                t.add("criteria", (JsonElement)criteria);
            }
        };
    }

    public static Consumer<JsonObject> makeStatRequirement(final StatBase base, final StatBase other, final int baseAmount, final int percent) {
        return new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                JsonObject criteria = new JsonObject();
                JsonObject hasStat = new JsonObject();
                hasStat.addProperty("trigger", new ResourceLocation("ic2", "has_stat").toString());
                JsonObject obj = new JsonObject();
                JsonObject stat = new JsonObject();
                stat.addProperty("type", "percent");
                stat.addProperty("baseStat", base.field_75975_e);
                stat.addProperty("otherStat", other.field_75975_e);
                stat.addProperty("baseAmount", (Number)baseAmount);
                stat.addProperty("percent", (Number)percent);
                obj.add("stat", (JsonElement)stat);
                hasStat.add("conditions", (JsonElement)obj);
                criteria.add("has_stat", (JsonElement)hasStat);
                t.add("criteria", (JsonElement)criteria);
            }
        };
    }

    public static Consumer<JsonObject> makeStackRequirement(final ItemStack stack) {
        return new Consumer<JsonObject>(){

            @Override
            public void accept(JsonObject t) {
                JsonObject criteria = new JsonObject();
                JsonObject hasItem = new JsonObject();
                criteria.add("has_item", (JsonElement)hasItem);
                hasItem.addProperty("trigger", "minecraft:inventory_changed");
                hasItem.add("conditions", (JsonElement)IC2Advancements.makeFromStack(new ItemWithMeta(stack)));
                t.add("criteria", (JsonElement)criteria);
            }
        };
    }

    private static JsonObject makeFromStack(ItemWithMeta meta) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", meta.getItem().getRegistryName().toString());
        obj.addProperty("data", (Number)meta.getMeta());
        JsonArray array = new JsonArray();
        array.add((JsonElement)obj);
        JsonObject result = new JsonObject();
        result.add("items", (JsonElement)array);
        return result;
    }
}

