/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.config.components.notifies;

import ic2.core.IC2;
import ic2.core.audio.AudioManagerClient;
import ic2.core.block.crop.renders.CropQuadStorage;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.energy.render.EnergyNetRenderer;
import ic2.core.platform.config.IC2Config;
import ic2.core.platform.config.components.IConfigNotify;
import ic2.core.platform.player.KeyboardClient;
import ic2.core.util.events.IC2WorldGenerator;
import ic2.core.util.misc.CreativeTabIC2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MainNotify
implements IConfigNotify {
    @Override
    public void onConfigReloaded(IC2Config config) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.loadClient(config);
        }
        IC2WorldGenerator.instance.updateConfig();
        EnergyNetLocal.easyMode = config.getFlag("IC2EasyMode");
        EnergyNetLocal.setBurn(config.getFloat("energyBurn"));
        CreativeTabIC2.seasonal = config.getFlag("Seasonal");
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClient(IC2Config config) {
        ((AudioManagerClient)IC2.audioManager).updateConfig();
        ((KeyboardClient)IC2.keyboard).updateConfig();
        EnergyNetRenderer.instance.setLimit(config.getInt("renderLimit"));
        int newCrop = config.getInt("cropRenderMode");
        if (CropQuadStorage.renderType != newCrop) {
            CropQuadStorage.renderType = newCrop;
            RenderGlobal global = Minecraft.func_71410_x().field_71438_f;
            if (global != null) {
                global.func_72712_a();
            }
        }
    }
}

