/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileServerEventPacket
extends IC2Packet {
    int dimID;
    BlockPos pos;
    int eventID;

    public TileServerEventPacket() {
    }

    public TileServerEventPacket(TileEntity par1, int par2) {
        this.dimID = par1.func_145831_w().field_73011_w.getDimension();
        this.pos = par1.func_174877_v();
        this.eventID = par2;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        this.pos = BlockPos.func_177969_a((long)par1.readLong());
        this.eventID = par1.readInt();
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeLong(this.pos.func_177986_g());
        par1.writeInt(this.eventID);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet was sended Wrong");
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile == null) {
            return;
        }
        if (!(tile instanceof INetworkTileEntityEventListener)) {
            throw new RuntimeException("Packet Contains Wrong Data");
        }
        ((INetworkTileEntityEventListener)tile).onNetworkEvent(this.eventID);
    }

    public String toString() {
        return "TileEntity Server Event Packet: Pos: " + this.pos.toString() + ", Event: " + this.eventID;
    }
}

