/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.buffers;

import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataOutput;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OutputBuffer
implements IOutputBuffer {
    ByteBuf buffer;

    public OutputBuffer(ByteBuf buf) {
        this.buffer = buf;
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.writeByte((int)value);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.writeShort((int)value);
    }

    @Override
    public void writeMedium(int value) {
        this.buffer.writeMedium(value);
    }

    @Override
    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.writeDouble(value);
    }

    @Override
    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    @Override
    public void writeData(long value, NetworkField.BitLevel type) {
        if (type.isSkip()) {
            return;
        }
        switch (type) {
            case Bit0: {
                break;
            }
            case Bit8: {
                this.buffer.writeByte((int)value);
                break;
            }
            case Bit16: {
                this.buffer.writeShort((int)value);
                break;
            }
            case Bit24: {
                this.buffer.writeMedium((int)value);
                break;
            }
            case Bit32: {
                this.buffer.writeInt((int)value);
                break;
            }
            case Bit40: {
                this.buffer.writeByte((int)((byte)(value >>> 32)));
                this.buffer.writeByte((int)((byte)(value >>> 24)));
                this.buffer.writeByte((int)((byte)(value >>> 16)));
                this.buffer.writeByte((int)((byte)(value >>> 8)));
                this.buffer.writeByte((int)((byte)value));
                break;
            }
            case Bit48: {
                this.buffer.writeByte((int)((byte)(value >>> 40)));
                this.buffer.writeByte((int)((byte)(value >>> 32)));
                this.buffer.writeByte((int)((byte)(value >>> 24)));
                this.buffer.writeByte((int)((byte)(value >>> 16)));
                this.buffer.writeByte((int)((byte)(value >>> 8)));
                this.buffer.writeByte((int)((byte)value));
                break;
            }
            case Bit56: {
                this.buffer.writeByte((int)((byte)(value >>> 48)));
                this.buffer.writeByte((int)((byte)(value >>> 40)));
                this.buffer.writeByte((int)((byte)(value >>> 32)));
                this.buffer.writeByte((int)((byte)(value >>> 24)));
                this.buffer.writeByte((int)((byte)(value >>> 16)));
                this.buffer.writeByte((int)((byte)(value >>> 8)));
                this.buffer.writeByte((int)((byte)value));
                break;
            }
            case Bit64: {
                this.buffer.writeLong(value);
            }
        }
    }

    @Override
    public void writeChar(char value) {
        this.buffer.writeChar((int)value);
    }

    @Override
    public void writeString(String value) {
        this.writeString(value, NetworkField.BitLevel.Bit32);
    }

    @Override
    public void writeString(String value, NetworkField.BitLevel length) {
        long limit = length.limitNumber(value.length());
        this.writeData(limit, length);
        int i = 0;
        while ((long)i < limit) {
            this.buffer.writeChar((int)value.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeBytes(byte[] value) {
        this.writeBytes(value, NetworkField.BitLevel.Bit32);
    }

    @Override
    public void writeBytes(byte[] value, NetworkField.BitLevel length) {
        this.writeData(value.length, length);
        this.buffer.writeBytes(value);
    }

    @Override
    public void writeNBTData(NBTTagCompound value) {
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)value, (DataOutput)new ByteBufOutputStream(this.buffer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeForgeEntry(IForgeRegistryEntry value) {
        ResourceLocation resource;
        ResourceLocation resourceLocation = resource = value == null ? null : value.getRegistryName();
        if (resource == null) {
            this.writeString("Empty", NetworkField.BitLevel.Bit16);
        } else {
            this.writeString(resource.toString(), NetworkField.BitLevel.Bit16);
        }
    }

    @Override
    public void writeUUID(UUID value) {
        this.buffer.writeLong(value.getMostSignificantBits());
        this.buffer.writeLong(value.getLeastSignificantBits());
    }

    public ByteBuf getBuf() {
        return this.buffer;
    }
}

