/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.event.MachineRecipeEvent;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExportUpgrade
extends BaseMetaUpgrade {
    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        if (this.getWorldTime(machine) % 20L == 0L) {
            this.exportItems(upgrade, machine);
        }
    }

    public void exportItems(ItemStack upgrade, IMachine machine) {
        TileEntity tile;
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            IItemTransporter mach = TransporterManager.manager.getTransporter(machine, true);
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (mach == null || target == null) {
                return;
            }
            if (this.isUpgraded(upgrade)) {
                ItemStack added;
                int max;
                int limit = this.getStackSize(upgrade);
                if (limit != (max = Math.min(limit, (int)(machine.getEnergy() * 3.0)))) {
                    return;
                }
                ItemStack stack = mach.removeItem(CommonFilters.Anything, dir.toFacing(), max, false);
                if (!stack.func_190926_b() && (added = target.addItem(stack, dir.getInverse().toFacing(), true)).func_190916_E() > 0) {
                    mach.removeItem(CommonFilters.Anything, dir.toFacing(), added.func_190916_E(), true);
                    machine.useEnergy(Math.max(1, added.func_190916_E() / 3), false);
                    this.addItem(this.getOwner(upgrade), machine, Arrays.asList(added.func_77946_l()));
                }
            } else {
                ItemStack added;
                ItemStack stack;
                int max;
                int limit = Math.min(9, upgrade.func_190916_E());
                for (int i = 0; i < limit && (max = Math.min(64, (int)(machine.getEnergy() * 3.0))) > 0 && !(stack = mach.removeItem(CommonFilters.Anything, dir.toFacing(), max, false)).func_190926_b() && (added = target.addItem(stack, dir.getInverse().toFacing(), true)).func_190916_E() > 0; ++i) {
                    mach.removeItem(CommonFilters.Anything, dir.toFacing(), added.func_190916_E(), true);
                    machine.useEnergy(Math.max(1, added.func_190916_E() / 3), false);
                    this.addItem(this.getOwner(upgrade), machine, Arrays.asList(added.func_77946_l()));
                }
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        this.exportItems(upgrade, machine);
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<IStackOutput> items) {
        TileEntity tile;
        if (!(machine instanceof TileEntity) || items.isEmpty()) {
            return;
        }
        if (items.size() < 1) {
            return;
        }
        if (items.size() == 1 && items.get(0).getStack().func_190916_E() < 4) {
            return;
        }
        if (this.isUpgraded(upgrade)) {
            return;
        }
        Direction dir = this.getDirection(upgrade);
        if (dir != null && (tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos())) != null) {
            IItemTransporter target = TransporterManager.manager.getTransporter(this.getInventory(upgrade, tile), true);
            if (target == null) {
                return;
            }
            int aviableItems = Math.min(64, (int)(machine.getEnergy() * 3.0));
            int itemsAdded = 0;
            ArrayList<IStackOutput> left = new ArrayList<IStackOutput>();
            ArrayList<ItemStack> eventList = new ArrayList<ItemStack>();
            while (!items.isEmpty() && aviableItems > 0) {
                IStackOutput out = items.remove(0);
                ItemStack item = out.getStack();
                if (item.func_190926_b()) continue;
                ItemStack split = item.func_77946_l();
                split.func_190920_e(Math.min(aviableItems, item.func_190916_E()));
                ItemStack added = target.addItem(split, dir.getInverse().toFacing(), true);
                if (added.func_190916_E() > 0) {
                    eventList.add(added.func_77946_l());
                    item.func_190918_g(added.func_190916_E());
                    itemsAdded += added.func_190916_E();
                    aviableItems -= added.func_190916_E();
                    if (item.func_190926_b()) continue;
                }
                left.add(out);
            }
            machine.useEnergy(Math.max(1, itemsAdded / 3), false);
            if (!left.isEmpty()) {
                items.addAll(left);
            }
            this.addItem(this.getOwner(upgrade), machine, eventList);
        }
    }

    public void addItem(UUID id, IMachine machine, List<ItemStack> list) {
        if (id == null || !(machine instanceof IRecipeMachine) || list.isEmpty()) {
            return;
        }
        MachineType type = ((IRecipeMachine)((Object)machine)).getType();
        if (type == null) {
            return;
        }
        EntityPlayerMP player = IC2.platform.getServer().func_184103_al().func_177451_a(id);
        if (player != null) {
            for (int i = 0; i < list.size(); ++i) {
                MachineRecipeEvent event;
                ItemStack toAdd = list.get(i);
                if (toAdd.func_190926_b() || (event = type.createEvent((EntityPlayer)player, toAdd, true)) == null) continue;
                MinecraftForge.EVENT_BUS.post((Event)event);
            }
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.ImportExport;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.exportUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[136];
    }

    @Override
    public boolean usesOwner() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }

    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> sortedTooltip) {
        if (this.isUpgraded(par1)) {
            sortedTooltip.get((Object)ToolTipType.Alt).add(Ic2InfoLang.upgradeStackSize.getLocalizedFormatted(this.getStackSize(par1)));
        }
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return this.isUpgraded(item);
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        PlayerHandler handler = PlayerHandler.getHandlerForPlayer(player);
        if (handler.modeSwitchKeyDown) {
            int amount;
            int n = amount = handler.altKeyDown ? 10 : 1;
            if (player.func_70093_af()) {
                amount = -amount;
            }
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
            int size = MathHelper.func_76125_a((int)(nbt.func_74762_e("Size") + amount), (int)1, (int)64);
            nbt.func_74768_a("Size", size);
            IC2.platform.messagePlayer(player, Ic2InfoLang.upgradeStackSize, size);
        }
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return this.isUpgraded(stack) ? 1 : 64;
    }

    public boolean isUpgraded(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Upgraded");
    }

    public int getStackSize(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("Size");
    }
}

