/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.inventory;

import ic2.api.classic.network.INetworkFieldData;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.item.inv.container.ContainerStackLimiter;
import ic2.core.item.inv.inventories.StackLimiterInv;
import ic2.core.item.recipe.entry.RecipeInputIgnoreNBT;
import ic2.core.item.upgrades.subtypes.inventory.BaseMetaInventoryUpgrade;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StackLimiterUpgrade
extends BaseMetaInventoryUpgrade
implements IHandHeldInventory {
    @Override
    public IInventoryModifier.EffectType getEffect() {
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.stackLimiterUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return Ic2Icons.getTextures("i1")[170];
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> list, boolean adv, Map<ToolTipType, List<String>> sortedToolTips) {
        List<String> altList = sortedToolTips.get((Object)ToolTipType.Alt);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        NBTTagList dataList = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < dataList.func_74745_c(); ++i) {
            NBTTagCompound data = dataList.func_150305_b(i);
            ItemStack item = new ItemStack(data);
            if (item.func_190926_b()) continue;
            altList.add(Ic2InfoLang.invUpgradeTypeStackSize.getLocalizedFormatted(item.func_82833_r(), data.func_74762_e("Amount")));
        }
        List<String> ctrlTip = sortedToolTips.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(3), Ic2Lang.openTheItemInventory));
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("Data")) {
            NBTTagList list = nbt.func_150295_c("Data", 10);
            boolean add = false;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                ItemStack item = new ItemStack(data);
                if (item.func_190926_b()) continue;
                handler.registerFilter(new RecipeInputIgnoreNBT(item, data.func_74762_e("Amount")));
                add = true;
            }
            if (add) {
                handler.allowOnlyOneStack();
            }
        }
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public ActionResult<ItemStack> onRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void onNetworkEvent(ItemStack networkStack, EntityPlayer player, INetworkFieldData data) {
        if (!(data instanceof PayloadFieldPacket)) {
            return;
        }
        PayloadFieldPacket packet = (PayloadFieldPacket)data;
        if (packet.getSize(1) != 2) {
            return;
        }
        if (!(player.field_71070_bA instanceof ContainerStackLimiter)) {
            return;
        }
        ContainerStackLimiter cont = (ContainerStackLimiter)player.field_71070_bA;
        int index = packet.getNumber(0);
        int movement = packet.getNumber(1);
        StackLimiterInv inv = (StackLimiterInv)cont.getGuiHolder();
        inv.maxStacksize[index] = MathHelper.func_76125_a((int)(inv.maxStacksize[index] + movement), (int)0, (int)128);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new StackLimiterInv(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }
}

