/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class FluidScanner
implements IScanner {
    @Override
    public boolean isAdv(ItemStack stack) {
        return true;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        Material mat;
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return 1;
        }
        if (block instanceof BlockStaticLiquid && block.func_176201_c(state) == 0 && ((mat = state.func_185904_a()) == Material.field_151587_i || mat == Material.field_151586_h)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        Material mat;
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (fluid.canDrain(world, pos)) {
                return fluid.drain(world, pos, false) != null ? 1 : 0;
            }
        } else if (block instanceof BlockStaticLiquid && block.func_176201_c(state) == 0 && ((mat = state.func_185904_a()) == Material.field_151587_i || mat == Material.field_151586_h)) {
            return 1;
        }
        return 0;
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return EMPTY_STATES;
    }

    @Override
    public int getRadius(ItemStack stack) {
        return 20;
    }

    @Override
    public int getCost(ItemStack stack) {
        return 100;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return true;
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return EMPTY_FLUIDS;
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return Ic2ItemLang.scannerFluid;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return false;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTooltip) {
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return false;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return false;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return false;
    }
}

