/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import ic2.api.classic.audio.PositionSpec;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.item.armor.electric.ItemArmorNanoSuit;
import ic2.core.item.armor.electric.ItemArmorQuantumSuit;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNanoSaber
extends ItemElectricTool
implements IStaticTexturedItem,
IAdvancedTexturedItem {
    public int soundTicker;
    public AudioSource sound;
    public ModelResourceLocation[] textures = new ModelResourceLocation[3];

    public ItemNanoSaber() {
        super(0.0f, 2.0f, Item.ToolMaterial.IRON);
        this.setTranslationKey(Ic2ItemLang.nanoSaberItem);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.field_77865_bY = 1.0f;
        this.soundTicker = 0;
        this.maxCharge = 40000;
        this.transferLimit = 128;
        this.operationEnergyCost = 10;
        this.tier = 2;
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get((Object)ToolTipType.Shift).add(Ic2InfoLang.nanoSaberEffect.getLocalized());
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Ic2Items.bronzeSword.func_150998_b(state);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.nanoSaber;
            }
            case 1: {
                return Ic2ItemLang.nanoSaberActive;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "item.itemNanoSaber";
            }
            case 1: {
                return "item.itemNanoSaberActive";
            }
        }
        return super.func_77667_c(stack);
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77960_j() == 0) {
            return true;
        }
        if (IC2.platform.isSimulating() && (!IC2.platform.isPVP() || attacker instanceof EntityPlayer)) {
            if (target instanceof EntityPlayer) {
                EntityPlayer targetPlayer = (EntityPlayer)target;
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    ItemStack armor;
                    if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR || (armor = targetPlayer.func_184582_a(slot)).func_190926_b()) continue;
                    boolean nano = armor.func_77973_b() instanceof ItemArmorNanoSuit;
                    boolean quantum = armor.func_77973_b() instanceof ItemArmorQuantumSuit;
                    if (!nano && !quantum) continue;
                    int usage = quantum ? 30000 : 4800;
                    ElectricItem.manager.discharge(armor, usage, Integer.MAX_VALUE, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        targetPlayer.func_184201_a(slot, ItemStack.field_190927_a);
                    }
                    ItemNanoSaber.drainSaber(stack, 16, attacker);
                }
            }
            ItemNanoSaber.drainSaber(stack, 40, attacker);
        }
        return true;
    }

    public static void drainSaber(ItemStack stack, int needed, EntityLivingBase base) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (!ElectricItem.manager.use(stack, needed, base)) {
            Items.field_151100_aR.setDamage(stack, 0);
        }
    }

    @Override
    public float getMiningSpeed(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            if (IC2.platform.isRendering()) {
                ++this.soundTicker;
                if (this.soundTicker % 4 == 0) {
                    IC2.audioManager.playOnce(IC2.platform.getPlayerInstance(), this.getRandomSwingSound());
                }
            }
            return 4.0f;
        }
        return 1.0f;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    public ResourceLocation getRandomSwingSound() {
        switch (IC2.random.nextInt(3)) {
            default: {
                return Ic2Sounds.nanoSabreSwingOne;
            }
            case 1: {
                return Ic2Sounds.nanoSabreSwingTwo;
            }
            case 2: 
        }
        return Ic2Sounds.nanoSabreSwingThree;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77960_j() == 1 && PlayerHandler.getHandlerForPlayer((EntityPlayer)playerIn).altKeyDown) {
            if (IC2.platform.isSimulating()) {
                Items.field_151100_aR.setDamage(stack, 0);
            }
            if (this.sound != null && !this.sound.isRemoved()) {
                this.sound.stop();
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (stack.func_77960_j() == 0 && ElectricItem.manager.canUse(stack, 16.0)) {
            if (IC2.platform.isSimulating()) {
                Items.field_151100_aR.setDamage(stack, 1);
            }
            if (this.sound != null) {
                if (this.sound.isRemoved()) {
                    this.sound = null;
                } else {
                    this.sound.stop();
                }
            }
            IC2.audioManager.playOnce(playerIn, PositionSpec.Hand, Ic2Sounds.nanoSabrePowerUp, false, 1.0f);
            if (this.sound == null || this.sound.isRemoved()) {
                this.sound = IC2.audioManager.createSource(playerIn, PositionSpec.Hand, Ic2Sounds.nanoSabre, true, false, 0.3f);
            }
            if (this.sound != null) {
                this.sound.play();
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean drain;
        if (!(entityIn instanceof EntityPlayer) || stack.func_77960_j() == 0) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
        int delay = nbt.func_74762_e("Delay");
        boolean bl = isSelected ? delay >= 16 : (drain = ++delay >= 64);
        if (drain) {
            delay = 0;
        }
        nbt.func_74768_a("Delay", delay);
        if (!drain) {
            return;
        }
        ItemNanoSaber.drainSaber(stack, 16, (EntityLivingBase)entityIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", stack.func_77960_j() == 0 ? 3.0 : 19.0, 0));
        }
        return map;
    }

    private boolean isInHand(EnumHand hand, EntityPlayer player) {
        return player.func_184586_b(hand).func_77973_b() == this;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[39 + meta];
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77960_j() != newStack.func_77960_j() || slotChanged;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        ModelResourceLocation location;
        String name = this.func_77667_c(stack);
        this.textures[stack.func_77960_j()] = location = new ModelResourceLocation(this.getRegistryName().func_110624_b() + name.substring(name.indexOf(".") + 1), "inventory");
        return location;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 0) {
            return this.textures[meta];
        }
        return this.textures[field_77697_d.nextBoolean() ? 1 : 2];
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.WEAPON;
    }
}

