/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.tile.ITeleporterTarget;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemFrequenceyTransmitter
extends ItemIC2
implements ICustomItemCameraTransform {
    public ItemFrequenceyTransmitter() {
        this.func_77625_d(1);
        this.setNoRepair();
        this.setTranslationKey(Ic2ItemLang.frequencyTransmitter);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74767_n("TargetSet")) {
            tooltip.add(Ic2InfoLang.freqTransmitterDim.getLocalizedFormatted(nbt.func_74762_e("dim")));
            tooltip.add(Ic2InfoLang.freqTransmitterX.getLocalizedFormatted(nbt.func_74762_e("xCoord")));
            tooltip.add(Ic2InfoLang.freqTransmitterY.getLocalizedFormatted(nbt.func_74762_e("yCoord")));
            tooltip.add(Ic2InfoLang.freqTransmitterZ.getLocalizedFormatted(nbt.func_74762_e("zCoord")));
        }
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 21;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (IC2.platform.isSimulating() && playerIn.func_70093_af()) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(playerIn.func_184586_b(handIn));
            if (nbtData.func_74767_n("Skip")) {
                nbtData.func_74757_a("Skip", false);
            } else if (nbtData.func_74767_n("TargetSet")) {
                nbtData.func_74757_a("TargetSet", false);
                IC2.platform.messagePlayer(playerIn, Ic2InfoLang.freqTransmitterClear);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        if (IC2.platform.isSimulating() && (tile = world.func_175625_s(pos)) instanceof ITeleporterTarget) {
            ITeleporterTarget teleporter = (ITeleporterTarget)tile;
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(player.func_184586_b(hand));
            boolean targetSet = nbt.func_74767_n("TargetSet");
            ITeleporterTarget.TeleporterTarget target = new ITeleporterTarget.TeleporterTarget(new BlockPos(nbt.func_74762_e("xCoord"), nbt.func_74762_e("yCoord"), nbt.func_74762_e("zCoord")), nbt.func_74762_e("dim"));
            TileEntity te = target.getTile();
            if (targetSet && !TileEntityTeleporter.isTeleporter(te)) {
                targetSet = false;
            }
            if (!targetSet) {
                targetSet = true;
                target = new ITeleporterTarget.TeleporterTarget((ITeleporterTarget)tile);
                IC2.platform.messagePlayer(player, Ic2InfoLang.freqTransmitterSetTarget);
            } else if (teleporter.getPosition().equals((Object)target.getPos()) && teleporter.getWorldObj().field_73011_w.getDimension() == target.getDimID()) {
                IC2.platform.messagePlayer(player, Ic2InfoLang.freqTransmitterSameTarget);
            } else {
                ITeleporterTarget.TeleporterTarget otherTarget;
                ITeleporterTarget tp;
                teleporter.setTarget(target);
                if (te instanceof ITeleporterTarget && !(tp = (ITeleporterTarget)te).hasTarget(otherTarget = new ITeleporterTarget.TeleporterTarget((ITeleporterTarget)tile))) {
                    tp.setTarget(otherTarget);
                }
                IC2.platform.messagePlayer(player, Ic2InfoLang.freqTransmitterUpdatedTarget);
            }
            nbt.func_74757_a("TargetSet", targetSet);
            BlockPos targetPos = target.getPos();
            nbt.func_74768_a("xCoord", targetPos.func_177958_n());
            nbt.func_74768_a("yCoord", targetPos.func_177956_o());
            nbt.func_74768_a("zCoord", targetPos.func_177952_p());
            nbt.func_74768_a("dim", target.getDimID());
            nbt.func_74757_a("Skip", player.func_70093_af());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }
}

