/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.render.model;

import ic2.core.item.tool.electric.ItemElectricToolObscurator;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.helpers.TextureOverrideList;
import ic2.core.platform.textures.helpers.TextureShaper;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.util.helpers.ToolHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class ObscuratorModel
extends BaseModel
implements TextureOverrideList.IModelUpdate {
    static Map<RenderEntry, List<BakedQuad>> quadStorage = new HashMap<RenderEntry, List<BakedQuad>>();
    static LinkedList<RenderEntry> lastUsed = new LinkedList();
    ItemElectricToolObscurator item;
    ObscuratorModel other;
    boolean gui;
    List<BakedQuad> renderQuads = new ArrayList<BakedQuad>();
    List<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
    RenderEntry lastEntry;
    private static final float North_Z_Offset = 0.468625f;
    private static final float South_Z_Offset = 0.531375f;

    public ObscuratorModel(TextureAtlasSprite par1, ItemElectricToolObscurator par2) {
        super(Ic2Models.getItemTransforms());
        this.setParticalTexture(par1);
        this.item = par2;
    }

    @Override
    public void init() {
        this.gui = false;
        this.other = new ObscuratorModel(this.func_177554_e(), this.item);
        this.other.gui = true;
        this.baseQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)this.func_177554_e(), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(this.getCamera().get((Object)ItemCameraTransforms.TransformType.GUI))));
        ArrayList quad = new ArrayList();
        for (BakedQuad cu : this.baseQuads) {
            if (cu.func_178210_d() != EnumFacing.SOUTH) continue;
            this.other.baseQuads.add(cu);
        }
        this.renderQuads.addAll(this.baseQuads);
        this.other.renderQuads.addAll(this.other.baseQuads);
        this.lastEntry = null;
        quadStorage.clear();
        lastUsed.clear();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side == null) {
            return this.renderQuads;
        }
        return this.getEmptyList();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return new TextureOverrideList(this);
    }

    @Override
    public void onUpdate(ItemStack stack) {
        if (this.item.hasBlock(stack)) {
            RenderEntry entry = new RenderEntry(this.item, stack);
            if (this.lastEntry == null || !this.lastEntry.equals(entry)) {
                List<BakedQuad> quads = quadStorage.get(entry);
                if (quads == null) {
                    quads = this.createQuads(entry);
                    quadStorage.put(entry, quads);
                    if (lastUsed.size() > 150) {
                        quadStorage.remove(lastUsed.remove());
                    }
                }
                lastUsed.remove(entry);
                lastUsed.add(entry);
                this.renderQuads = new ArrayList<BakedQuad>();
                this.renderQuads.addAll(this.baseQuads);
                this.renderQuads.addAll(quads);
                this.other.renderQuads = new ArrayList<BakedQuad>();
                this.other.renderQuads.addAll(this.other.baseQuads);
                this.other.renderQuads.addAll(quads);
            }
        } else if (this.lastEntry != null) {
            this.lastEntry = null;
            this.renderQuads = new ArrayList<BakedQuad>();
            this.renderQuads.addAll(this.baseQuads);
            this.other.renderQuads = new ArrayList<BakedQuad>();
            this.other.renderQuads.addAll(this.other.baseQuads);
        }
    }

    private List<BakedQuad> createQuads(RenderEntry entry) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(entry.model);
        List quads = model.func_188616_a(entry.render, entry.side, 0L);
        if (quads.isEmpty()) {
            return new ArrayList<BakedQuad>();
        }
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(20);
        int colorState = 0;
        for (BakedQuad quad : quads) {
            UnpackedBakedQuad un = TextureShaper.genQuad(DefaultVertexFormats.field_176599_b, (TRSRTransformation)this.getCamera().get((Object)ItemCameraTransforms.TransformType.FIXED), 6.0f, 2.0f, 14.0f, 10.0f, 0.468625f, quad.func_187508_a(), EnumFacing.NORTH, -1);
            result.add(new BakedQuad(un.func_178209_a(), quad.func_178212_b() ? colorState : -1, un.func_178210_d(), un.func_187508_a(), un.shouldApplyDiffuseLighting(), un.getFormat()));
            un = TextureShaper.genQuad(DefaultVertexFormats.field_176599_b, (TRSRTransformation)this.getCamera().get((Object)ItemCameraTransforms.TransformType.FIXED), 6.0f, 2.0f, 14.0f, 10.0f, 0.531375f, quad.func_187508_a(), EnumFacing.SOUTH, -1);
            result.add(new BakedQuad(un.func_178209_a(), quad.func_178212_b() ? colorState : -1, un.func_178210_d(), un.func_187508_a(), un.shouldApplyDiffuseLighting(), un.getFormat()));
            ++colorState;
        }
        return result;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI && !this.gui && pair.getRight() == null) {
            return Pair.of((Object)this.other, null);
        }
        if (cameraTransformType != ItemCameraTransforms.TransformType.GUI && this.gui) {
            return Pair.of((Object)this.other, (Object)pair.getRight());
        }
        return pair;
    }

    public static class RenderEntry {
        IBlockState model;
        IBlockState render;
        EnumFacing side;
        int hash;

        public RenderEntry(ItemElectricToolObscurator item, ItemStack stack) {
            Block block = item.getBlock(stack);
            this.model = ToolHelper.stringToBlockState(block, item.getModelState(stack));
            this.render = ToolHelper.stringToBlockState(block, item.getRenderState(stack));
            this.side = item.getSide(stack);
            this.hash = Objects.hash(this.side, this.model, this.render);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenderEntry) {
                RenderEntry entry = (RenderEntry)obj;
                return this.side == entry.side && Objects.equals(this.model, entry.model) && Objects.equals(this.render, entry.render);
            }
            return false;
        }
    }
}

