/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.base;

import ic2.api.classic.reactor.IReactorPlanner;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.core.IC2;
import ic2.core.item.base.ItemGrandualInt;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.util.helpers.ItemStackCoord;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemUraniumRodBase
extends ItemGrandualInt
implements ISteamReactorComponent,
IReactorPlannerComponent {
    public abstract IUranium getUranium(ItemStack var1);

    public abstract IUranium.RodType getRodType(ItemStack var1);

    public abstract int getRodAmount(ItemStack var1);

    public abstract IUranium getUranium(int var1);

    public abstract IUranium.RodType getRodType(int var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return this.getUranium(meta).getTexture(this.getRodType(meta));
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getUranium(stack).getName(this.getRodType(stack.func_77960_j()));
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.getUranium(stack).getMaxDurability();
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getRodAmount(stack);
        IUranium uran = this.getUranium(stack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulsePerTick = uran.getPulsesPerTick();
            int pulses = (1 + count / 2) * pulsePerTick;
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(stack, reactor, stack, x, y, x, y, heatrun);
                }
                for (i = 0; i < pulsePerTick; ++i) {
                    for (int[] nArray : uran.getPulseArea(i)) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], stack, x, y, heatrun, uran);
                    }
                }
                continue;
            }
            for (i = 0; i < pulsePerTick; ++i) {
                for (int[] nArray : uran.getPulseArea(i)) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], stack, x, y, heatrun, uran);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            LinkedList<ItemStackCoord> targets = new LinkedList<ItemStackCoord>();
            for (int[] array4 : uran.getAcceptorTargets()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], targets);
            }
            while (targets.size() > 0 && heat > 0) {
                int n = heat / targets.size();
                heat -= n;
                ItemStackCoord target = (ItemStackCoord)targets.remove();
                int n2 = ((IReactorComponent)target.stack.func_77973_b()).alterHeat(target.stack, reactor, target.x, target.y, n);
                heat += n2;
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (this.getCustomDamage(stack) + 1 > this.getMaxCustomDamage(stack)) {
            if (IC2.random.nextInt(3) == 0) {
                reactor.setItemAt(x, y, StackUtil.copyWithSize(uran.getRodType(IUranium.RodType.NearDepletedRod), count));
            } else {
                reactor.setItemAt(x, y, ItemStack.field_190927_a);
            }
        } else if (heatrun) {
            this.setCustomDamage(stack, this.getCustomDamage(stack) + 1);
        }
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
        if (!reactor.produceEnergy()) {
            return;
        }
        int count = this.getRodAmount(yourStack);
        IUranium uran = this.getUranium(yourStack);
        for (int iteration = 0; iteration < count; ++iteration) {
            int i;
            int pulsePerTick = uran.getPulsesPerTick();
            int pulses = (1 + count / 2) * pulsePerTick;
            if (!heatrun) {
                for (i = 0; i < pulses; ++i) {
                    this.acceptUraniumPulse(yourStack, reactor, yourStack, x, y, x, y, heatrun);
                }
                for (i = 0; i < pulsePerTick; ++i) {
                    for (int[] nArray : uran.getPulseArea(i)) {
                        pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, uran);
                    }
                }
                continue;
            }
            for (i = 0; i < pulsePerTick; ++i) {
                for (int[] nArray : uran.getPulseArea(i)) {
                    pulses += this.checkPulseable(reactor, x + nArray[0], y + nArray[1], yourStack, x, y, damageTick, uran);
                }
            }
            int heat = (int)((float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            LinkedList<ItemStackCoord> targets = new LinkedList<ItemStackCoord>();
            for (int[] array4 : uran.getAcceptorTargets()) {
                this.checkHeatAcceptor(reactor, x + array4[0], y + array4[1], targets);
            }
            while (targets.size() > 0 && heat > 0) {
                int n = heat / targets.size();
                heat -= n;
                ItemStackCoord target = (ItemStackCoord)targets.remove();
                int n2 = ((IReactorComponent)target.stack.func_77973_b()).alterHeat(target.stack, reactor, target.x, target.y, n);
                heat += n2;
            }
            if (heat <= 0) continue;
            reactor.addHeat(heat);
        }
        if (damageTick) {
            if (this.getCustomDamage(yourStack) + 1 > this.getMaxCustomDamage(yourStack)) {
                if (IC2.random.nextInt(3) == 0) {
                    reactor.setItemAt(x, y, StackUtil.copyWithSize(uran.getRodType(IUranium.RodType.NearDepletedRod), count));
                } else {
                    reactor.setItemAt(x, y, ItemStack.field_190927_a);
                }
            } else {
                this.setCustomDamage(yourStack, this.getCustomDamage(yourStack) + 1);
            }
        }
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        IReactorPlanner planner;
        if (reactor instanceof IReactorPlanner && (planner = (IReactorPlanner)reactor).isCollecting()) {
            planner.addFuelPulse();
        }
        if (reactor instanceof ISteamReactor) {
            return true;
        }
        if (!heatrun) {
            reactor.addOutput(this.getUranium(stack).getEUPerPulse());
        }
        return true;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return false;
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        return heat;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return this.getUranium(stack).getExplosionEffectModifier() * (float)this.getRodAmount(stack);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        super.applyCustomDamage(stack, damage, src);
        return this.getCustomDamage(stack) > this.getMaxCustomDamage(stack);
    }

    @Override
    public short getID(ItemStack stack) {
        return this.getUranium(stack).getRodID(this.getRodType(stack));
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.FuelRod;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        IUranium uran = this.getUranium(stack);
        int rodAmount = this.getRodAmount(stack);
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            for (int i = 0; i < rodAmount; ++i) {
                amount = (int)((float)amount + (float)(this.sumUp((1 + rodAmount / 2) * uran.getPulsesPerTick()) * 4) * uran.getHeatModifier());
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            float amount = 0.0f;
            for (int i = 0; i < rodAmount; ++i) {
                int pulses = (1 + rodAmount / 2) * uran.getPulsesPerTick();
                for (int z = 0; z < pulses; ++z) {
                    amount += uran.getEUPerPulse();
                }
            }
            return new NBTTagFloat(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.MaxDurability) {
            return new NBTTagInt(this.getMaxCustomDamage(stack));
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.RodAmount) {
            return new NBTTagInt(rodAmount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.PulseAmount) {
            return new NBTTagInt((1 + rodAmount / 2) * uran.getPulsesPerTick() * rodAmount);
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction || stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        IUranium uran = this.getUranium(stack);
        int rodAmount = this.getRodAmount(stack);
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatProduction) {
            int amount = 0;
            int pulsePerTick = uran.getPulsesPerTick();
            for (int i = 0; i < rodAmount; ++i) {
                int pulses = (1 + rodAmount / 2) * uran.getPulsesPerTick();
                for (int z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : uran.getPulseArea(z)) {
                        pulses += this.checkPulseable(reactor, x + array[0], y + array[1], stack, x, y, false, uran);
                    }
                }
                amount = (int)((float)amount + (float)(this.sumUp(pulses) * 4) * uran.getHeatModifier());
            }
            return new NBTTagInt(amount);
        }
        if (stat == IReactorPlannerComponent.ReactorComponentStat.EnergyProduction) {
            for (int i = 0; i < rodAmount; ++i) {
                int z;
                int pulsePerTick = uran.getPulsesPerTick();
                int pulses = (1 + rodAmount / 2) * pulsePerTick;
                for (z = 0; z < pulses; ++z) {
                    this.acceptUraniumPulse(stack, reactor, stack, x, y, x, y, false);
                }
                for (z = 0; z < pulsePerTick; ++z) {
                    for (int[] array : uran.getPulseArea(z)) {
                        pulses += this.checkPulseable(reactor, x + array[0], y + array[1], stack, x, y, false, uran);
                    }
                }
            }
            return new NBTTagFloat(reactor.getReactorEnergyOutput());
        }
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }

    protected int checkPulseable(IReactor reactor, int x, int y, ItemStack me, int mex, int mey, boolean heatrun, IUranium type) {
        ItemStack other = reactor.getItemAt(x, y);
        if (other.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)other.func_77973_b()).acceptUraniumPulse(other, reactor, me, x, y, mex, mey, heatrun)) {
            return type.getPulsesForConnection();
        }
        return 0;
    }

    protected void checkHeatAcceptor(IReactor reactor, int x, int y, List<ItemStackCoord> heatAcceptors) {
        ItemStack thing = reactor.getItemAt(x, y);
        if (thing.func_77973_b() instanceof IReactorComponent && ((IReactorComponent)thing.func_77973_b()).canStoreHeat(thing, reactor, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
        }
    }

    protected int sumUp(int x) {
        int sum = 0;
        for (int i = 1; i <= x; ++i) {
            sum += i;
        }
        return sum;
    }
}

