/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactor;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactor;
import ic2.core.item.base.ItemGrandualInt;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.NonNullList;

public class ItemReactorCondensator
extends ItemGrandualInt
implements IReactorPlannerComponent,
ISteamReactorComponent,
IBootable {
    public ItemReactorCondensator() {
        this.setTranslationKey(Ic2ItemLang.condensators);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        Ic2Items.reactorCondensator = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorCondensatorLap = new ItemStack((Item)this, 1, 1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        items.add((Object)new ItemStack((Item)this, 1, 1));
    }

    @Override
    public void processChamber(ItemStack stack, IReactor reactor, int x, int y, boolean heatrun) {
    }

    @Override
    public boolean acceptUraniumPulse(ItemStack stack, IReactor reactor, ItemStack pulsingStack, int youX, int youY, int pulseX, int pulseY, boolean heatrun) {
        return false;
    }

    @Override
    public boolean canStoreHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return this.getCustomDamage(stack) + 1 < this.getMaxCustomDamage(stack);
    }

    @Override
    public int getMaxHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return this.getMaxCustomDamage(stack);
    }

    @Override
    public int getCurrentHeat(ItemStack stack, IReactor reactor, int x, int y) {
        return 0;
    }

    @Override
    public int alterHeat(ItemStack stack, IReactor reactor, int x, int y, int heat) {
        int can = this.getMaxCustomDamage(stack) - (this.getCustomDamage(stack) + 1);
        if (can > heat) {
            can = heat;
        }
        this.setCustomDamage(stack, this.getCustomDamage(stack) + can);
        return heat -= can;
    }

    @Override
    public float influenceExplosion(ItemStack stack, IReactor reactor) {
        return 0.0f;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 5 + meta;
    }

    @Override
    public String getSheet(int meta) {
        return "i3";
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.condensatorRed;
            }
            case 1: {
                return Ic2ItemLang.condensatorLap;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 20000;
            }
            case 1: {
                return 100000;
            }
        }
        return super.getMaxCustomDamage(stack);
    }

    @Override
    public void processTick(ISteamReactor reactor, ItemStack yourStack, int x, int y, boolean heatrun, boolean damageTick) {
    }

    @Override
    public ItemStack[] getSubParts() {
        return new ItemStack[]{new ItemStack((Item)this, 1, 0), new ItemStack((Item)this, 1, 1)};
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }

    @Override
    public short getID(ItemStack stack) {
        return (short)(15 + stack.func_77960_j());
    }

    @Override
    public IReactorPlannerComponent.ReactorComponentType getType(ItemStack stack) {
        return IReactorPlannerComponent.ReactorComponentType.Conensator;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        if (stat == IReactorPlannerComponent.ReactorComponentStat.HeatStorage) {
            return new NBTTagInt(this.getMaxCustomDamage(stack));
        }
        return nulltag;
    }

    @Override
    public boolean isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat stat, ItemStack stack) {
        return false;
    }

    @Override
    public NBTPrimitive getReactorStat(IReactor reactor, int x, int y, ItemStack stack, IReactorPlannerComponent.ReactorComponentStat stat) {
        return nulltag;
    }

    @Override
    public IReactorPlannerComponent.ReactorType getReactorInfo(ItemStack stack) {
        return IReactorPlannerComponent.ReactorType.Both;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return true;
    }

    @Override
    public List<IReactorPlannerComponent.ReactorComponentStat> getExtraStats(ItemStack stack) {
        return null;
    }
}

