/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.api.classic.reactor.IReactorProduct;
import ic2.api.item.IBoxable;
import ic2.api.reactor.IReactor;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.obj.IBootable;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMisc
extends ItemIC2
implements IStaticTexturedItem,
IBootable,
IReactorProduct,
IBoxable {
    public Int2ObjectMap<LocaleComp> unlocalizedNames = new Int2ObjectLinkedOpenHashMap();
    public Int2ObjectMap<Texture> textures = new Int2ObjectLinkedOpenHashMap();

    public ItemMisc() {
        this.setTranslationKey(Ic2ItemLang.miscItem);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.setNoRepair();
    }

    @Override
    public void onLoad() {
        this.addEntry(0, "itemDustIron", 1);
        this.addEntry(1, "itemDustGold", 2);
        this.addEntry(2, "itemDustCopper", 3);
        this.addEntry(3, "itemDustTin", 4);
        this.addEntry(4, "itemDustBronze", 5);
        this.addEntry(5, "itemDustSilver", 7);
        this.addEntry(6, "itemDustCoal", 0);
        this.addEntry(7, "itemFuelCoalDust", 8);
        this.addEntry(8, "itemDustClay", 6);
        this.addEntry(9, "itemObsidianDust", 9);
        this.addEntry(11, "itemNetherrackDust", 12);
        this.addEntry(12, "itemCharcoalDust", 13);
        this.addEntry(13, "itemFuelCharcoalDust", 14);
        this.addEntry(14, "itemRareEarthDust", 15);
        this.addEntry(50, "itemIngotCopper", 17);
        this.addEntry(51, "itemIngotTin", 18);
        this.addEntry(52, "itemIngotBronze", 19);
        this.addEntry(53, "itemIngotAdvIron", 16);
        this.addEntry(54, "itemIngotSilver", 22);
        this.addEntry(55, "itemIngotUran", 21);
        this.addEntry(56, "itemIngotAlloy", 20);
        this.addEntry(57, "itemRedstoneEnrichedUranium", 23);
        this.addEntry(58, "itemBlazeEnrichedUranium", 24);
        this.addEntry(59, "itemEnderPearlEnrichedUranium", 25);
        this.addEntry(60, "itemNetherStarEnrichedUranium", 26);
        this.addEntry(61, "itemCharcoalEnrichedUranium", 27);
        this.addEntry(100, "itemCellAir", 38);
        this.addEntry(101, "itemCellCoal", 36);
        this.addEntry(102, "itemCellCoalRef", 35);
        this.addEntry(103, "itemCellBio", 41);
        this.addEntry(104, "itemCellBioRef", 37);
        this.addEntry(105, "itemCellWaterElectro", 39);
        this.addEntry(106, "itemCellFuel", 43);
        this.addEntry(108, "itemCellPlasma", 45);
        this.addEntry(150, "itemGrinPowder", 81);
        this.addEntry(151, "itemFertilizer", 80);
        this.addEntry(152, "itemHops", 85);
        this.addEntry(153, "itemCoffeeBeans", 83);
        this.addEntry(154, "itemCoffeePowder", 84);
        this.addEntry(155, "itemTeaLeaf", 86);
        this.addEntry(156, "itemFlour", 11);
        this.addEntry(157, "itemSpecialFertilizer", 89);
        this.addEntry(158, "itemHempSeeds", 90);
        this.addEntry(159, "itemHemp", 91);
        this.addEntry(160, "itemReviveFertilizer", 92);
        this.addEntry(180, "itemOreUran", 61);
        this.addEntry(181, "itemOreIridium", 59);
        this.addEntry(200, "itemScrap", 65);
        this.addEntry(201, "itemScrapMetal", 67);
        this.addEntry(202, "itemMatter", 64);
        this.addEntry(250, "itemPartCoalBall", 48);
        this.addEntry(251, "itemPartCoalBlock", 49);
        this.addEntry(252, "itemPartCoalChunk", 50);
        this.addEntry(253, "itemPartIndustrialDiamond", 51);
        this.addEntry(254, "itemPartCarbonFibre", 52);
        this.addEntry(255, "itemPartCarbonMesh", 53);
        this.addEntry(256, "itemPartCarbonPlate", 54);
        this.addEntry(257, "itemPartAlloy", 55);
        this.addEntry(258, "itemPartIridium", 60);
        this.addEntry(259, "itemPartDCP", 58);
        this.addEntry(260, "itemUpgradeBase", 147);
        this.addEntry(261, "itemRareEarthChunk", 213);
        this.addEntry(262, "itemDeadMagnet", 214);
        this.addEntry(263, "itemMagnet", 215);
        this.addEntry(264, "itemPlasmaCore", 216);
        this.addEntry(300, "scrapMetalChunk", 68);
        this.addEntry(301, "scrapMetalBlade", 69);
        this.addEntry(302, "itemRawObsidianBlade", 70);
        this.addEntry(303, "itemObsidianBlade", 71);
        this.addEntry(304, "itemTurbineBlade", 62);
        this.addEntry(350, "itemFuelPlantBall", 76);
        this.addEntry(351, "itemFuelPlantCmpr", 77);
        this.addEntry(352, "itemFuelCoalCmpr", 75);
        this.addEntry(353, "itemBioMesh", 208);
        this.addEntry(354, "itemBioBall", 209);
        this.addEntry(355, "itemRawBioFiber", 210);
        this.addEntry(356, "itemCompressedBioBall", 211);
        this.addEntry(357, "itemBioChunk", 212);
        this.addEntry(400, "itemToolPainter", 80, "i1");
        this.addEntry(401, "itemTFBP", 96, "i1");
        this.addEntry(402, "itemTerraformerBiomeBlueprint", 128, "i1");
        this.addEntry(450, "itemRubber", 74);
        this.addEntry(451, "itemPartCircuit", 56);
        this.addEntry(452, "itemPartCircuitAdv", 57);
        this.addEntry(453, "itemTinCan", 78);
        this.addEntry(454, "itemMugEmpty", 176);
        this.addEntry(455, "itemPartPellet", 72);
        this.addEntry(500, Ic2ItemLang.uranRodNearDeplete, 144, "i3");
        this.addEntry(501, Ic2ItemLang.uranRodRedstoneNearDeplete, 145, "i3");
        this.addEntry(502, Ic2ItemLang.uranRodBlazeNearDeplete, 146, "i3");
        this.addEntry(503, Ic2ItemLang.uranRodEnderNearDeplete, 147, "i3");
        this.addEntry(504, Ic2ItemLang.uranRodNetherStarNearDeplete, 148, "i3");
        this.addEntry(505, Ic2ItemLang.uranRodCharcoalNearDeplete, 149, "i3");
        this.addEntry(550, Ic2ItemLang.uranRodReEnriched, 176, "i3");
        this.addEntry(551, Ic2ItemLang.uranRodRedstoneReEnriched, 177, "i3");
        this.addEntry(552, Ic2ItemLang.uranRodBlazeReEnriched, 178, "i3");
        this.addEntry(553, Ic2ItemLang.uranRodEnderReEnriched, 179, "i3");
        this.addEntry(554, Ic2ItemLang.uranRodNetherStarReEnriched, 180, "i3");
        this.addEntry(555, Ic2ItemLang.uranRodCharcoalReEnriched, 181, "i3");
        Ic2Items.ironDust = new ItemStack((Item)this, 1, 0);
        Ic2Items.goldDust = new ItemStack((Item)this, 1, 1);
        Ic2Items.copperDust = new ItemStack((Item)this, 1, 2);
        Ic2Items.tinDust = new ItemStack((Item)this, 1, 3);
        Ic2Items.bronzeDust = new ItemStack((Item)this, 1, 4);
        Ic2Items.silverDust = new ItemStack((Item)this, 1, 5);
        Ic2Items.coalDust = new ItemStack((Item)this, 1, 6);
        Ic2Items.hydratedCoalDust = new ItemStack((Item)this, 1, 7);
        Ic2Items.clayDust = new ItemStack((Item)this, 1, 8);
        Ic2Items.obsidianDust = new ItemStack((Item)this, 1, 9);
        Ic2Items.netherrackDust = new ItemStack((Item)this, 1, 11);
        Ic2Items.charcoalDust = new ItemStack((Item)this, 1, 12);
        Ic2Items.hydratedCharCoalDust = new ItemStack((Item)this, 1, 13);
        Ic2Items.rareEarthDust = new ItemStack((Item)this, 1, 14);
        Ic2Items.copperIngot = new ItemStack((Item)this, 1, 50);
        Ic2Items.tinIngot = new ItemStack((Item)this, 1, 51);
        Ic2Items.bronzeIngot = new ItemStack((Item)this, 1, 52);
        Ic2Items.refinedIronIngot = new ItemStack((Item)this, 1, 53);
        Ic2Items.silverIngot = new ItemStack((Item)this, 1, 54);
        Ic2Items.uraniumIngot = new ItemStack((Item)this, 1, 55);
        Ic2Items.mixedMetalIngot = new ItemStack((Item)this, 1, 56);
        Ic2Items.redstoneUraniumIngot = new ItemStack((Item)this, 1, 57);
        Ic2Items.blazeUraniumIngot = new ItemStack((Item)this, 1, 58);
        Ic2Items.enderPearlUraniumIngot = new ItemStack((Item)this, 1, 59);
        Ic2Items.netherStarUraniumIngot = new ItemStack((Item)this, 1, 60);
        Ic2Items.charcoalUraniumIngot = new ItemStack((Item)this, 1, 61);
        Ic2Items.airCell = new ItemStack((Item)this, 1, 100);
        Ic2Items.hydratedCoalCell = new ItemStack((Item)this, 1, 101);
        Ic2Items.coalFuelCell = new ItemStack((Item)this, 1, 102);
        Ic2Items.bioCell = new ItemStack((Item)this, 1, 103);
        Ic2Items.bioFuelCell = new ItemStack((Item)this, 1, 104);
        Ic2Items.electrolyzedWaterCell = new ItemStack((Item)this, 1, 105);
        Ic2Items.fuelCell = new ItemStack((Item)this, 1, 106);
        Ic2Items.plasmaCell = new ItemStack((Item)this, 1, 108);
        Ic2Items.grinPowder = new ItemStack((Item)this, 1, 150);
        Ic2Items.fertilizer = new ItemStack((Item)this, 1, 151);
        Ic2Items.hops = new ItemStack((Item)this, 1, 152);
        Ic2Items.coffeeBeans = new ItemStack((Item)this, 1, 153);
        Ic2Items.coffeePowder = new ItemStack((Item)this, 1, 154);
        Ic2Items.teaLeaf = new ItemStack((Item)this, 1, 155);
        Ic2Items.flour = new ItemStack((Item)this, 1, 156);
        Ic2Items.overgrowthFertilizer = new ItemStack((Item)this, 1, 157);
        Ic2Items.hempSeeds = new ItemStack((Item)this, 1, 158);
        Ic2Items.hemp = new ItemStack((Item)this, 1, 159);
        Ic2Items.reviveFertilizer = new ItemStack((Item)this, 1, 160);
        Ic2Items.uraniumDrop = new ItemStack((Item)this, 1, 180);
        Ic2Items.iridiumOre = new ItemStack((Item)this, 1, 181);
        Ic2Items.scrap = new ItemStack((Item)this, 1, 200);
        Ic2Items.scrapMetal = new ItemStack((Item)this, 1, 201);
        Ic2Items.uuMatter = new ItemStack((Item)this, 1, 202);
        Ic2Items.coalBall = new ItemStack((Item)this, 1, 250);
        Ic2Items.compressedCoalBall = new ItemStack((Item)this, 1, 251);
        Ic2Items.coalChunk = new ItemStack((Item)this, 1, 252);
        Ic2Items.industrialDiamond = new ItemStack((Item)this, 1, 253);
        Ic2Items.carbonFiber = new ItemStack((Item)this, 1, 254);
        Ic2Items.carbonMesh = new ItemStack((Item)this, 1, 255);
        Ic2Items.carbonPlate = new ItemStack((Item)this, 1, 256);
        Ic2Items.advancedAlloy = new ItemStack((Item)this, 1, 257);
        Ic2Items.iridiumPlate = new ItemStack((Item)this, 1, 258);
        Ic2Items.denseCopperPlate = new ItemStack((Item)this, 1, 259);
        Ic2Items.upgradeBase = new ItemStack((Item)this, 1, 260);
        Ic2Items.rareEarthChunk = new ItemStack((Item)this, 1, 261);
        Ic2Items.deadMagnet = new ItemStack((Item)this, 1, 262);
        Ic2Items.magnet = new ItemStack((Item)this, 1, 263);
        Ic2Items.plasmaCore = new ItemStack((Item)this, 1, 264);
        Ic2Items.scrapMetalChunk = new ItemStack((Item)this, 1, 300);
        Ic2Items.scrapMetalBlade = new ItemStack((Item)this, 1, 301);
        Ic2Items.rawObsidianBlade = new ItemStack((Item)this, 1, 302);
        Ic2Items.obsidianBlade = new ItemStack((Item)this, 1, 303);
        Ic2Items.turbineBlade = new ItemStack((Item)this, 1, 304);
        Ic2Items.plantBall = new ItemStack((Item)this, 1, 350);
        Ic2Items.compressedPlantBall = new ItemStack((Item)this, 1, 351);
        Ic2Items.hydratedCoalClump = new ItemStack((Item)this, 1, 352);
        Ic2Items.bioMesh = new ItemStack((Item)this, 1, 353);
        Ic2Items.bioBall = new ItemStack((Item)this, 1, 354);
        Ic2Items.bioRawFiber = new ItemStack((Item)this, 1, 355);
        Ic2Items.bioCompressedBall = new ItemStack((Item)this, 1, 356);
        Ic2Items.bioChunk = new ItemStack((Item)this, 1, 357);
        Ic2Items.painter = new ItemStack((Item)this, 1, 400);
        Ic2Items.tfbp = new ItemStack((Item)this, 1, 401);
        Ic2Items.tfbpBiome = new ItemStack((Item)this, 1, 402);
        Ic2Items.rubber = new ItemStack((Item)this, 1, 450);
        Ic2Items.electricCircuit = new ItemStack((Item)this, 1, 451);
        Ic2Items.advancedCircuit = new ItemStack((Item)this, 1, 452);
        Ic2Items.tinCan = new ItemStack((Item)this, 1, 453);
        Ic2Items.emptyMug = new ItemStack((Item)this, 1, 454);
        Ic2Items.constructionFoamPellet = new ItemStack((Item)this, 1, 455);
        Ic2Items.reactorNearDepletedUraniumRod = new ItemStack((Item)this, 1, 500);
        Ic2Items.reactorNearDepletedRedstoneUraniumRod = new ItemStack((Item)this, 1, 501);
        Ic2Items.reactorNearDepletedBlazeUraniumRod = new ItemStack((Item)this, 1, 502);
        Ic2Items.reactorNearDepletedEnderPearlUraniumRod = new ItemStack((Item)this, 1, 503);
        Ic2Items.reactorNearDepletedNetherStarUraniumRod = new ItemStack((Item)this, 1, 504);
        Ic2Items.reactorNearDepletedCharcoalUraniumRod = new ItemStack((Item)this, 1, 505);
        Ic2Items.reactorReEnrichedUraniumRod = new ItemStack((Item)this, 1, 550);
        Ic2Items.reactorReEnrichedRedstoneUraniumRod = new ItemStack((Item)this, 1, 551);
        Ic2Items.reactorReEnrichedBlazeUraniumRod = new ItemStack((Item)this, 1, 552);
        Ic2Items.reactorReEnrichedEnderPearlUraniumRod = new ItemStack((Item)this, 1, 553);
        Ic2Items.reactorReEnrichedNetherStarUraniumRod = new ItemStack((Item)this, 1, 554);
        Ic2Items.reactorReEnrichedCharcoalUraniumRod = new ItemStack((Item)this, 1, 555);
        ToolHelper.bronzeToolMaterial.setRepairItem(Ic2Items.bronzeIngot);
    }

    private void addEntry(int meta, String name, int texture) {
        this.addEntry(meta, name, texture, "i0");
    }

    private void addEntry(int meta, String name, int texture, String sprite) {
        this.unlocalizedNames.put(meta, (Object)new LangComponentHolder.LocaleItemComp("item." + name));
        this.textures.put(meta, (Object)new Texture(sprite, texture));
    }

    private void addEntry(int meta, LocaleComp comp, int texture, String sprite) {
        this.unlocalizedNames.put(meta, (Object)comp);
        this.textures.put(meta, (Object)new Texture(sprite, texture));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 157) {
            return EnumRarity.UNCOMMON;
        }
        if (meta == 452) {
            return EnumRarity.UNCOMMON;
        }
        if (meta == 160) {
            return EnumRarity.EPIC;
        }
        return EnumRarity.COMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 157 || meta == 160) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    @Override
    public List<Integer> getValidVariants() {
        return new ArrayList<Integer>((Collection<Integer>)this.textures.keySet());
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        int meta = stack.func_77960_j();
        return meta >= 100 && meta <= 106 || meta >= 250 && meta <= 259 || meta >= 450 && meta <= 455 || meta >= 500 && meta <= 505 || meta >= 550 && meta <= 555;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        Texture tex = (Texture)this.textures.get(meta);
        if (tex == null) {
            return null;
        }
        return Ic2Icons.getTextures(tex.sprite)[tex.pos];
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        LocaleComp comp = (LocaleComp)this.unlocalizedNames.get(stack.func_77960_j());
        if (comp != null) {
            return comp;
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ArrayList list = new ArrayList(this.textures.keySet());
        Collections.sort(list);
        for (Integer key : list) {
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77960_j() == 108) {
            tooltip.add(Ic2InfoLang.madeInPlasma.getLocalized());
        }
    }

    @Override
    public boolean isProduct(ItemStack item) {
        int meta = item.func_77960_j();
        return meta >= 500 && meta <= 505 || meta >= 550 && meta <= 555 || meta == 106;
    }

    @Override
    public boolean canBePlacedIn(ItemStack stack, IReactor reactor) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return stack.func_77960_j() == 454;
    }

    static class Texture {
        String sprite;
        int pos;

        public Texture(String par1, int par2) {
            this.sprite = par1;
            this.pos = par2;
        }
    }
}

