/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.misc;

import ic2.core.IC2;
import ic2.core.fluid.FluidCellHandler;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemCell
extends ItemIC2
implements IBootable {
    public ItemCell() {
        this.func_77625_d(64);
        this.setTranslationKey(Ic2ItemLang.cellEmpty);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        Ic2Items.emptyCell = new ItemStack((Item)this, 1, 0);
        Ic2Items.waterCell = new ItemStack((Item)this, 1, 1);
        Ic2Items.lavaCell = new ItemStack((Item)this, 1, 2);
        Ic2Items.woodGasCell = new ItemStack((Item)this, 1, 3);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return Ic2ItemLang.cellWater;
            }
            case 2: {
                return Ic2ItemLang.cellLava;
            }
            case 3: {
                return Ic2ItemLang.cellWoodgas;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3);
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    @Override
    public int getTextureEntry(int meta) {
        if (meta == 1) {
            return 34;
        }
        if (meta == 2) {
            return 33;
        }
        if (meta == 3) {
            return 44;
        }
        return 32;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidCellHandler(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77960_j() != 0) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult trace = this.func_77621_a(worldIn, playerIn, true);
        if (trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.func_178782_a();
        if (!worldIn.func_175660_a(playerIn, pos)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        BlockPos offsetPos = pos.func_177972_a(trace.field_178784_b);
        if (!playerIn.func_175151_a(offsetPos, trace.field_178784_b, stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        Material mat = state.func_185904_a();
        int meta = block.func_176201_c(state);
        if (IC2.platform.isRendering()) {
            if (mat == Material.field_151586_h && meta == 0 || mat == Material.field_151587_i && meta == 0) {
                playerIn.func_184185_a(mat == Material.field_151587_i ? SoundEvents.field_187633_N : SoundEvents.field_187630_M, 1.0f, 2.0f);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        boolean found = false;
        if (mat == Material.field_151586_h && meta == 0 && this.storeCell(Ic2Items.waterCell.func_77946_l(), playerIn)) {
            stack.func_190918_g(1);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            playerIn.func_184185_a(SoundEvents.field_187630_M, 1.0f, 2.0f);
            found = true;
        } else if (mat == Material.field_151587_i && meta == 0 && this.storeCell(Ic2Items.lavaCell.func_77946_l(), playerIn)) {
            stack.func_190918_g(1);
            playerIn.func_184185_a(SoundEvents.field_187633_N, 1.0f, 2.0f);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            found = true;
        }
        if (!found) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        worldIn.func_175698_g(pos);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean storeCell(ItemStack cell, EntityPlayer player) {
        if (player.field_71071_by.func_70441_a(cell)) {
            player.field_71070_bA.func_75142_b();
            return true;
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }
}

