/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.core.IC2;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemMugCoffee
extends ItemIC2
implements IBootable {
    public ItemMugCoffee() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.coffee);
        this.func_77625_d(16);
    }

    @Override
    public void onLoad() {
        Ic2Items.coldCoffee = new ItemStack((Item)this, 1, 0);
        Ic2Items.darkCoffee = new ItemStack((Item)this, 1, 1);
        Ic2Items.coffee = new ItemStack((Item)this, 1, 2);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 177 + meta;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        IC2.achievements.issueStat(player, "coffeeLover");
        int meta = stack.func_77960_j();
        int highest = 0;
        int x = this.amplifyEffect(player, MobEffects.field_76424_c, meta);
        if (x > highest) {
            highest = x;
        }
        if ((x = this.amplifyEffect(player, MobEffects.field_76422_e, meta)) > highest) {
            highest = x;
        }
        if (meta == 2) {
            highest -= 2;
        }
        if (highest >= 3) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, (highest - 2) * 200, 0));
            if (highest >= 4) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, highest - 3));
            }
        }
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            return Ic2Items.emptyMug.func_77946_l();
        }
        this.addMugToPlayer(player);
        return stack;
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.coffeeDark;
            }
            case 1: {
                return Ic2ItemLang.coffeeDark;
            }
            case 2: {
                return Ic2ItemLang.coffee;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "item.coffee0";
            }
            case 1: {
                return "item.coffee1";
            }
            case 2: {
                return "item.coffee2";
            }
        }
        return super.func_77667_c(stack);
    }

    public int amplifyEffect(EntityPlayer player, Potion potion, int meta) {
        PotionEffect eff = player.func_70660_b(potion);
        if (eff != null) {
            int max = 1;
            if (meta == 1) {
                max = 5;
            }
            if (meta == 2) {
                max = 6;
            }
            int newAmp = eff.func_76458_c();
            int newDur = eff.func_76459_b();
            if (newAmp < max) {
                ++newAmp;
            }
            newDur = meta == 0 ? (newDur += 600) : (newDur += 1200);
            eff.func_76452_a(new PotionEffect(eff.func_188419_a(), newDur, newAmp));
            return newAmp;
        }
        player.func_70690_d(new PotionEffect(potion, 300, 0));
        return 1;
    }

    public void addMugToPlayer(EntityPlayer player) {
        if (player.field_71071_by.func_70441_a(Ic2Items.emptyMug.func_77946_l())) {
            player.field_71070_bA.func_75142_b();
        } else {
            player.func_71019_a(Ic2Items.emptyMug.func_77946_l(), false);
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }
}

