/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.base;

import com.google.common.base.Strings;
import ic2.core.IC2;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemIC2ArmorBase
extends ItemArmor
implements IStaticTexturedItem {
    public LocaleComp name;
    int index;

    public ItemIC2ArmorBase(ItemArmor.ArmorMaterial materialIn, int index, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, -1, equipmentSlotIn);
        this.index = index;
        this.func_77637_a(IC2.tabIC2);
        this.name = Ic2Lang.nullKey;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        EnumMap<ToolTipType, List<String>> dataMap = new EnumMap<ToolTipType, List<String>>(ToolTipType.class);
        dataMap.put(ToolTipType.Ctrl, new LinkedList());
        dataMap.put(ToolTipType.Shift, new LinkedList());
        dataMap.put(ToolTipType.Alt, new LinkedList());
        this.onSortedItemToolTip(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, advanced.func_194127_a(), tooltip, dataMap);
        for (ToolTipType type : new ToolTipType[]{ToolTipType.Alt, ToolTipType.Shift, ToolTipType.Ctrl}) {
            List text = (List)dataMap.get((Object)type);
            if (text.size() <= 0) continue;
            if (type.isKeyDown()) {
                text.add("");
                tooltip.addAll(1, text);
                continue;
            }
            tooltip.add(1, type.getTypeInfo());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i2")[this.index];
    }

    public abstract String getTexture();

    public abstract ItemStack getRepairItem();

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        boolean overlay;
        String name = this.getTexture() + "_";
        boolean bl = overlay = !Strings.isNullOrEmpty((String)type);
        if (slot == EntityEquipmentSlot.LEGS) {
            if (overlay) {
                return name + "2_" + type + ".png";
            }
            return name + "2.png";
        }
        if (overlay) {
            return name + "1_" + type + ".png";
        }
        return name + "1.png";
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack repairItem = this.getRepairItem();
        if (repairItem == null) {
            return false;
        }
        return StackUtil.isStackEqual(repairItem, repair);
    }

    public boolean hasOverlay(ItemStack stack) {
        return false;
    }

    public LocaleComp getLangComponent() {
        return this.name;
    }

    public LocaleComp getLangComponent(ItemStack stack) {
        return this.getLangComponent();
    }

    public Item setTranslationKey(LocaleComp component) {
        this.name = component;
        return super.func_77655_b(component.getUnlocalized());
    }

    public Item func_77655_b(String unlocalizedName) {
        this.name = new LangComponentHolder.LocaleItemComp("item." + unlocalizedName);
        return super.func_77655_b(unlocalizedName);
    }

    public String func_77658_a() {
        return this.getLangComponent().getUnlocalized();
    }

    public String func_77667_c(ItemStack stack) {
        return this.getLangComponent(stack).getUnlocalized();
    }

    public String func_77657_g(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }

    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalized();
    }
}

