/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.personal.tile.TileEntityPersonalEnergyStorage;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PersonalEnergyStorageComp
extends GuiComponent {
    TileEntityPersonalEnergyStorage block;

    public PersonalEnergyStorageComp(TileEntityPersonalEnergyStorage tile) {
        super(Ic2GuiComp.nullBox);
        this.block = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.BackgroundDraw);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString(Ic2GuiLang.energyStorageCharge, 79, 25, 0x404040);
        int eu = this.block.storage.stored;
        int max = this.block.storage.maxEnergy;
        if (eu > max) {
            eu = max;
        }
        gui.drawString("" + eu, 110, 35, 0x404040);
        gui.drawString("/" + max, 110, 45, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int eu = this.block.getStoredEU();
        if (eu > 0) {
            int lvl;
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            float per = (float)eu / (float)this.block.getMaxEU();
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 24.0f)) <= 0) {
                return;
            }
            gui.func_73729_b(x + 79, y + 34, 176, 14, lvl, 16);
        }
    }
}

