/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.base;

import ic2.core.fluid.LayeredFluidTank;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidTankComp
extends GuiComponent {
    IFluidTank tank;
    Box2D tooltipBox;
    Vec2i pos;

    public FluidTankComp(Box2D box, IFluidTank fluid, Vec2i vec, Box2D secBox) {
        super(box);
        this.tank = fluid;
        this.pos = vec;
        this.tooltipBox = secBox;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        Box2D box = this.getPosition();
        if (this.tank instanceof LayeredFluidTank) {
            gui.displayMultiGaugge(gui.getXOffset(), gui.getYOffset(), this.pos.getX(), this.pos.getY(), box.getX(), box.getY(), gui.getTextureObject(), (LayeredFluidTank)this.tank);
        } else {
            int max = (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * 58.0f);
            gui.displayGauge(gui.getXOffset(), gui.getYOffset(), this.pos.getX(), this.pos.getY(), box.getX(), box.getY(), max, gui.getTextureObject(), this.tank.getFluid());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.tooltipBox.isInBox(mouseX, mouseY)) {
            if (this.tank instanceof LayeredFluidTank) {
                LayeredFluidTank layer = (LayeredFluidTank)this.tank;
                tooltips.add(Ic2GuiLang.fluidTank.getLocalized());
                IFluidTankProperties[] props = layer.getTankProperties();
                for (int i = 0; i < props.length; ++i) {
                    FluidStack fluid = props[i].getContents();
                    tooltips.add(Ic2GuiLang.fluidStored.getLocalizedFormatted(fluid != null ? fluid.getLocalizedName() : Ic2GuiLang.fluidNone));
                    tooltips.add(Ic2GuiLang.fluidAmount.getLocalizedFormatted(fluid != null ? fluid.amount : 0, this.tank.getCapacity()));
                    if (i + 1 >= props.length) continue;
                    tooltips.add("");
                }
            } else {
                FluidStack fluid = this.tank.getFluid();
                tooltips.add(Ic2GuiLang.fluidTank.getLocalized());
                tooltips.add(Ic2GuiLang.fluidStored.getLocalizedFormatted(fluid != null ? fluid.getLocalizedName() : Ic2GuiLang.fluidNone));
                tooltips.add(Ic2GuiLang.fluidAmount.getLocalizedFormatted(this.tank.getFluidAmount(), this.tank.getCapacity()));
            }
        }
    }
}

