/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.base;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IPortableInventory;
import ic2.core.util.misc.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public abstract class IC2ItemInventory
implements IPortableInventory {
    int id;
    ItemStack stack;
    public NonNullList<ItemStack> inventory;

    public IC2ItemInventory(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        this.stack = item.func_77946_l();
        this.id = player.field_70170_p.field_73012_v.nextInt(Integer.MAX_VALUE);
        inv.setGuiID(item, this.id);
        this.readFromNBT(StackUtil.getOrCreateNbtData(item));
    }

    public abstract int getInventorySize();

    public int getID() {
        return this.id;
    }

    @Override
    public ItemStack getInventoryStack() {
        return this.stack;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        if (IC2.platform.isSimulating()) {
            ItemStack stack = this.getInv(player);
            if (!stack.func_190926_b()) {
                this.writeToNBT(StackUtil.getOrCreateNbtData(stack));
                ((IHandHeldInventory)stack.func_77973_b()).setGuiID(stack, -1);
                this.onClose(stack);
            } else {
                ItemStack items = this.getInventoryStack();
                for (int i = 0; i < this.getInventorySize(); ++i) {
                    if (!this.isContainer(this.getStackInSlot(i))) continue;
                    this.setStackInSlot(i, ItemStack.field_190927_a);
                    this.writeToNBT(StackUtil.getOrCreateNbtData(items));
                    ((IHandHeldInventory)items.func_77973_b()).setGuiID(items, -1);
                    this.onClose(items);
                    StackUtil.dropAsEntity(player.func_130014_f_(), player.func_180425_c(), items);
                    return;
                }
            }
        }
    }

    public void onClose(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public ItemStack getInv(EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        ItemStack stack = inv.func_70445_o();
        if (this.isContainer(stack)) {
            stack = this.getInventoryStack();
            inv.func_70437_b(stack);
            return stack;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!this.isContainer(inv.func_70301_a(i))) continue;
            ItemStack invSlot = this.getInventoryStack().func_77946_l();
            inv.func_70299_a(i, invSlot);
            return invSlot;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isContainer(ItemStack toCheck) {
        if (!(toCheck.func_77973_b() instanceof IHandHeldInventory)) {
            return false;
        }
        return this.id == ((IHandHeldInventory)toCheck.func_77973_b()).getGuiId(toCheck);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Override
    public int getSlotCount() {
        return this.getInventorySize();
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.inventory = NonNullList.func_191197_a((int)this.getInventorySize(), (Object)ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c(this.getInventoryTag(), 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set(slot, (Object)new ItemStack(data));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(data);
            items.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a(this.getInventoryTag(), (NBTBase)items);
    }

    protected String getInventoryTag() {
        return "Items";
    }
}

