/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.misc;

import com.google.common.math.DoubleMath;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.energy.EnergyNet;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.block.wiring.tile.TileEntityBatteryStation;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.math.IntCounter;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class SlotInformation
implements INetworkFieldData {
    Set<Integer> filledSlots = new FilteredList<Integer>();
    int[] energy = new int[9];
    int[] maxEnergy = new int[9];
    byte[] tier = new byte[9];
    byte[] provider = new byte[9];
    int offerState = 0;
    byte maxTier = (byte)-1;
    final TileEntityBatteryStation station;

    public SlotInformation(TileEntityBatteryStation par1) {
        this.station = par1;
    }

    public List<Integer> asList() {
        return (List)((Object)this.filledSlots);
    }

    public void updateAll() {
        this.energy = new int[9];
        this.maxEnergy = new int[9];
        this.tier = new byte[9];
        this.provider = new byte[9];
        this.maxTier = (byte)-1;
        for (int i = 0; i < 9; ++i) {
            this.updateSlot(i);
        }
        this.setFirstSlot();
        this.makeMaxTier();
    }

    public void updateSlot(int slot) {
        ItemStack stack = this.station.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            this.energy[slot] = 0;
            this.maxEnergy[slot] = 0;
            this.tier[slot] = 0;
            this.provider[slot] = 0;
            this.filledSlots.remove(slot);
        } else {
            this.energy[slot] = (int)ElectricItem.manager.getCharge(stack);
            this.maxEnergy[slot] = (int)ElectricItem.manager.getMaxCharge(stack);
            this.tier[slot] = this.getTier(ElectricItem.manager.getTier(stack));
            this.provider[slot] = (byte)((stack.func_77973_b() instanceof IElectricItem ? ((IElectricItem)stack.func_77973_b()).canProvideEnergy(stack) : false) ? 1 : 0);
            this.filledSlots.add(slot);
        }
        this.maxTier = (byte)-1;
    }

    public int getSlotCount() {
        return this.filledSlots.size();
    }

    public int getMaxCharge() {
        int max = 0;
        for (Integer slot : this.filledSlots) {
            max += this.maxEnergy[slot];
        }
        return max;
    }

    public int getCharge() {
        int charge = 0;
        for (Integer slot : this.filledSlots) {
            charge += this.energy[slot];
        }
        return charge;
    }

    public int getProviderCharge() {
        return (int)EnergyNet.instance.getPowerFromTier(this.makeMaxTier());
    }

    private byte getTier(int tier) {
        if (tier > 13) {
            return 13;
        }
        return (byte)tier;
    }

    public double charge(double input) {
        if (this.filledSlots.isEmpty()) {
            return input;
        }
        for (Integer slot : this.filledSlots) {
            if ((input -= this.charge(slot, input)) < 1.0) break;
        }
        return input;
    }

    public double charge(int slot, double input) {
        double used = 0.0;
        if (this.filledSlots.contains(slot)) {
            int charged = (int)ElectricItem.manager.charge(this.station.getStackInSlot(slot), input, this.tier[slot], false, false);
            used += (double)charged;
            int n = slot;
            this.energy[n] = this.energy[n] + charged;
        }
        return used;
    }

    public void draw(double amount) {
        switch (this.station.sendingMode) {
            case 0: {
                this.draw(this.offerState, amount);
                break;
            }
            case 1: {
                this.drawAll(amount);
                break;
            }
            case 2: {
                this.draw(this.offerState, amount);
            }
        }
    }

    public void drawAll(double amount) {
        for (Integer slot : this.filledSlots) {
            this.draw(slot, Math.min(amount, Math.min((double)this.energy[slot], EnergyNet.instance.getPowerFromTier(this.tier[slot]))));
        }
    }

    public void draw(int slot, double amount) {
        if (this.filledSlots.contains(slot)) {
            int n = slot;
            this.energy[n] = (int)((double)this.energy[n] - ElectricItem.manager.discharge(this.station.getStackInSlot(slot), DoubleMath.roundToInt((double)amount, (RoundingMode)RoundingMode.UP), this.tier[slot], true, true, false));
        }
    }

    public int getTier() {
        switch (this.station.sendingMode) {
            case 0: {
                return this.tier[this.offerState];
            }
            case 1: {
                return this.makeMaxTier();
            }
            case 2: {
                return this.tier[this.offerState];
            }
        }
        return 0;
    }

    public int makeMaxTier() {
        if (this.maxTier != -1) {
            return this.maxTier;
        }
        LinkedHashMap<Integer, IntCounter> map = new LinkedHashMap<Integer, IntCounter>();
        byte highestTier = 0;
        for (Integer slot : this.filledSlots) {
            byte currentTier = this.tier[slot];
            IntCounter counter = (IntCounter)map.get(currentTier);
            if (counter == null) {
                counter = new IntCounter(0);
                map.put(Integer.valueOf(currentTier), counter);
            }
            counter.increase();
            if (currentTier <= highestTier) continue;
            highestTier = currentTier;
        }
        double endTier = highestTier;
        for (Map.Entry entry : map.entrySet()) {
            IntCounter counter = (IntCounter)entry.getValue();
            endTier += (double)counter.getValue() / Math.pow(4.0, highestTier + 1 - (Integer)entry.getKey());
        }
        this.maxTier = (byte)endTier;
        return this.maxTier;
    }

    public double getOffer() {
        switch (this.station.sendingMode) {
            case 0: {
                return Math.min((double)this.energy[this.offerState], EnergyNet.instance.getPowerFromTier(this.tier[this.offerState]));
            }
            case 1: {
                return Math.min((double)this.station.storedEnergy, EnergyNet.instance.getPowerFromTier(this.makeMaxTier()));
            }
            case 2: {
                double result = Math.min((double)this.energy[this.offerState], EnergyNet.instance.getPowerFromTier(this.tier[this.offerState]));
                if (result < 1.0) {
                    this.setFirstSlot();
                }
                return result;
            }
        }
        return 0.0;
    }

    public void setFirstSlot() {
        Collections.sort(this.asList());
        for (Integer slot : this.filledSlots) {
            if (this.provider[slot] != 1 || this.energy[slot] <= 0) continue;
            this.offerState = slot.byteValue();
            return;
        }
        this.offerState = 0;
    }

    public void updateDrawSlot() {
        if (this.filledSlots.isEmpty()) {
            return;
        }
        this.offerState = (byte)(++this.offerState % 9);
        int run = 0;
        while (!(this.filledSlots.contains(this.offerState) && this.provider[this.offerState] == 1 && this.energy[this.offerState] > 0 || run++ >= 9)) {
            this.offerState = (byte)(this.offerState++ % 9);
        }
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.offerState = buffer.readByte();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        try {
            buffer.writeByte((byte)this.offerState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, IntCounter> getSlotInfo() {
        LinkedHashMap<Integer, IntCounter> map = new LinkedHashMap<Integer, IntCounter>();
        for (Integer slot : this.filledSlots) {
            if (this.provider[slot] != 1) continue;
            int currentTier = (int)EnergyNet.instance.getPowerFromTier(this.tier[slot]);
            IntCounter counter = (IntCounter)map.get(currentTier);
            if (counter == null) {
                counter = new IntCounter(0);
                map.put(currentTier, counter);
            }
            counter.increase();
        }
        return map;
    }
}

