/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.tile;

import ic2.core.IC2;
import ic2.core.block.personal.tile.TileEntityPersonalChest;
import ic2.core.block.render.tile.ModelPersonalChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderPersonalChest
extends TileEntitySpecialRenderer<TileEntityPersonalChest> {
    ModelPersonalChest model = new ModelPersonalChest();
    public static final TileEntityPersonalChest itemRender = new TileEntityPersonalChest();
    private static final ResourceLocation TEXTURE = new ResourceLocation("ic2", "textures/models/tile/newsafe.png");

    public void render(TileEntityPersonalChest safe, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (safe == null) {
            safe = itemRender;
            safe.setFacingWithoutNotify(EnumFacing.NORTH);
        }
        this.tick(safe);
        this.func_147499_a(TEXTURE);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        float angle = safe.getFacing().func_185119_l();
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float moveAngle = safe.prevLidAngle + (safe.lidAngle - safe.prevLidAngle) * partialTicks;
        moveAngle = 1.0f - moveAngle;
        moveAngle = 1.0f - moveAngle * moveAngle * moveAngle;
        this.model.door.field_78796_g = moveAngle * 3.141593f / 2.0f;
        this.model.renderAll();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void tick(TileEntityPersonalChest tile) {
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = tile.func_174877_v();
        tile.prevLidAngle = tile.lidAngle;
        float var1 = 0.025f;
        if (tile.numUsingPlayers > 0 && tile.lidAngle == 0.0f) {
            IC2.audioManager.playOnce(tile, SoundEvents.field_187657_V.func_187503_a());
        }
        if (tile.numUsingPlayers == 0 && tile.lidAngle > 0.0f || tile.numUsingPlayers > 0 && tile.lidAngle < 1.0f) {
            float var5;
            float var4 = tile.lidAngle;
            tile.lidAngle = tile.numUsingPlayers > 0 ? (tile.lidAngle += var1) : (tile.lidAngle -= var1);
            if (tile.lidAngle > 1.0f) {
                tile.lidAngle = 1.0f;
            }
            if (tile.lidAngle < (var5 = 0.3f) && var4 >= var5) {
                IC2.audioManager.playOnce(tile, SoundEvents.field_187651_T.func_187503_a());
            }
            if (tile.lidAngle < 0.0f) {
                tile.lidAngle = 0.0f;
            }
        }
    }
}

