/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.model;

import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class BlockDoorModel
extends BaseModel {
    static float[][] closedArray = new float[][]{{13.0f, 0.0f, 16.0f, 16.0f}, {3.0f, 0.0f, 0.0f, 16.0f}, {0.0f, 0.0f, 3.0f, 16.0f}, {0.0f, 0.0f, 16.0f, 16.0f}, {16.0f, 0.0f, 0.0f, 16.0f}};
    static float[][] openArray = new float[][]{{13.0f, 0.0f, 16.0f, 16.0f}, {3.0f, 0.0f, 0.0f, 16.0f}, {0.0f, 0.0f, 3.0f, 16.0f}, {16.0f, 0.0f, 0.0f, 16.0f}, {0.0f, 0.0f, 16.0f, 16.0f}};
    static EnumFacing[] upper = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    static EnumFacing[] lower = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    IBlockState state;
    List<BakedQuad> quads = new ArrayList<BakedQuad>();

    public BlockDoorModel(IBlockState state) {
        super(Ic2Models.getBlockTransforms());
        this.state = state;
        this.setParticalTexture(state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Ic2Icons.getTextures("b0")[15] : Ic2Icons.getTextures("b0")[14]);
    }

    @Override
    public void init() {
        FaceBakery bake = this.getBakery();
        boolean up = this.state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER;
        boolean open = (Boolean)this.state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        boolean leftSided = this.state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.LEFT;
        EnumFacing[] array = up ? upper : lower;
        float[][] data = open && leftSided ? openArray : closedArray;
        ModelRotation rotation = this.getRotation(open, leftSided, (EnumFacing)this.state.func_177229_b((IProperty)BlockDoor.field_176520_a));
        for (int i = 0; i < array.length; ++i) {
            EnumFacing side = array[i];
            BlockPartFace face = new BlockPartFace(side == EnumFacing.EAST ? null : side, -1, "", new BlockFaceUV(data[i], 0));
            this.quads.add(bake.func_178414_a(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(3.0f, 16.0f, 16.0f), face, this.getTexture(up, side), array[i], rotation, null, true, true));
        }
    }

    public TextureAtlasSprite getTexture(boolean up, EnumFacing facing) {
        if (up) {
            return facing == EnumFacing.UP ? Ic2Icons.getTextures("b0")[15] : Ic2Icons.getTextures("b0")[14];
        }
        return Ic2Icons.getTextures("b0")[15];
    }

    public ModelRotation getRotation(boolean open, boolean leftSided, EnumFacing rotation) {
        if (!open) {
            switch (rotation) {
                case EAST: {
                    return ModelRotation.X0_Y0;
                }
                case NORTH: {
                    return ModelRotation.X0_Y270;
                }
                case SOUTH: {
                    return ModelRotation.X0_Y90;
                }
                case WEST: {
                    return ModelRotation.X0_Y180;
                }
            }
            return ModelRotation.X0_Y0;
        }
        if (leftSided) {
            switch (rotation) {
                case EAST: {
                    return ModelRotation.X0_Y90;
                }
                case NORTH: {
                    return ModelRotation.X0_Y0;
                }
                case SOUTH: {
                    return ModelRotation.X0_Y180;
                }
                case WEST: {
                    return ModelRotation.X0_Y270;
                }
            }
            return ModelRotation.X0_Y0;
        }
        switch (rotation) {
            case EAST: {
                return ModelRotation.X0_Y270;
            }
            case NORTH: {
                return ModelRotation.X0_Y180;
            }
            case SOUTH: {
                return ModelRotation.X0_Y0;
            }
            case WEST: {
                return ModelRotation.X0_Y90;
            }
        }
        return ModelRotation.X0_Y0;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null || side != null) {
            return this.getEmptyList();
        }
        return this.quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }
}

