/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.api.classic.network.ICustomNetworkClientTileEventListener;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.trading.providers.IFluidTradeProvider;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.personal.base.TileEntityTradeOMatBase;
import ic2.core.block.personal.base.misc.IOwnerBlock;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.IPersonalTank;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.base.trades.builder.FluidInventory;
import ic2.core.block.personal.base.trades.builder.FluidTradeFabricator;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.base.trades.builder.TradeInventoryPlayer;
import ic2.core.block.personal.container.ContainerFluidOMatClosed;
import ic2.core.block.personal.container.ContainerFluidOMatOpen;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.misc.FluidHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidOMat
extends TileEntityTradeOMatBase
implements IOwnerBlock,
IFluidTradeProvider,
IHasGui,
INetworkClientTileEventListener,
ICustomNetworkClientTileEventListener {
    @NetworkField(index=3)
    UUID owner;
    @NetworkField(index=4)
    public int state = 0;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int currentSubTrade = 0;
    public PersonalInventory display = new PersonalInventory(8);
    public FluidInventory fluidDisplay = new FluidInventory(8);
    public FluidTradeFabricator fab = new FluidTradeFabricator();
    Map<UUID, IPersonalInventory> tradersMap = new HashMap<UUID, IPersonalInventory>();

    public TileEntityFluidOMat() {
        this.addNetworkFields("owner");
    }

    @Override
    public TradeType getType() {
        return TradeType.Fluid;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.fluidOMat;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(UUID user) {
        if (this.owner == null && user != null) {
            this.owner = user;
            this.getNetwork().updateTileEntityField(this, "owner");
        }
    }

    @Override
    public boolean canAccess(UUID user) {
        if (this.owner == null) {
            this.setOwner(user);
            return true;
        }
        return this.owner.equals(user);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_186855_b("BlockOwner")) {
            this.owner = nbt.func_186857_a("BlockOwner");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.owner != null) {
            nbt.func_186854_a("BlockOwner", this.owner);
        }
        return nbt;
    }

    @Override
    public FluidStack getNearbyFluidStack(FluidStack asked, boolean simulate) {
        FluidStack got = asked.copy();
        got.amount = 0;
        boolean doDrain = !simulate;
        for (Direction dir : Direction.directions) {
            FluidStack handlerFluid;
            IFluidHandler handler;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || (handler = this.getHandler(tile, dir.getInverse().toFacing())) == null || !asked.isFluidEqual(handlerFluid = handler.drain(asked, doDrain))) continue;
            got.amount += handlerFluid.amount;
            if (got.amount >= asked.amount) break;
        }
        if (got.amount > 0) {
            return got;
        }
        return null;
    }

    public IFluidHandler getHandler(TileEntity tile, EnumFacing side) {
        IPersonalTank tank;
        if (tile instanceof IPersonalTank && (tank = (IPersonalTank)tile).canAccess(this.getOwner())) {
            return tank.getTank(this.getOwner());
        }
        return null;
    }

    public IPersonalInventory getInvForPlayer(EntityPlayer player) {
        return this.getInvForPlayer(player.func_110124_au());
    }

    public IPersonalInventory getInvForPlayer(UUID player) {
        IPersonalInventory inv = this.tradersMap.get(player);
        if (inv == null) {
            inv = new PersonalInventory(16);
            this.tradersMap.put(player, inv);
        }
        return inv;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.isSimulating()) {
            this.getSyncer().createDataForPlayer(player);
        }
        if (this.canAccess(player.func_110124_au()) && !IC2.keyboard.isSideinventoryKeyDown(player)) {
            return new ContainerFluidOMatOpen(player.field_71071_by, this);
        }
        return new ContainerFluidOMatClosed(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
        this.getSyncer().clearDataForPlayer(player);
        this.tradersMap.remove(player.func_110124_au());
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void onClientNetworkEvent(EntityPlayer player, INetworkFieldData data) {
        if (player == null) {
            return;
        }
        if (data instanceof PayloadFieldPacket) {
            PayloadFieldPacket payload = (PayloadFieldPacket)data;
            if (this.isOwner(player) && payload.getSize(0) == 1) {
                this.addTrade(IC2.manager.getCustomTrades(this.getType()).get(payload.getString(0)));
            }
            if (payload.getSize(1) == 1) {
                if (player.field_71070_bA instanceof ContainerFluidOMatClosed) {
                    ISubTrade sub;
                    ContainerFluidOMatClosed cont = (ContainerFluidOMatClosed)player.field_71070_bA;
                    UUID playerID = player.func_110124_au();
                    ITrade trade = this.getSyncer().getServerTrade(player);
                    cont.stockCount = trade != null && trade.canAccessTrade(playerID) ? ((sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true)) != null && sub.canPerformTrade(playerID) ? trade.getStockCount(sub, this, playerID) : 0) : 0;
                    cont.func_75142_b();
                }
            } else if (payload.getSize(1) == 2) {
                UUID playerID = player.func_110124_au();
                ITrade trade = this.getSyncer().getServerTrade(player);
                if (trade != null && trade.canAccessTrade(playerID)) {
                    ISubTrade sub = trade.getSubTradeFromSlot(payload.getNumber(0), playerID, true);
                    if (sub != null && sub.canPerformTrade(playerID)) {
                        List<FluidStack> fluids = trade.getTradeResults(sub);
                        IPersonalInventory inv = this.getInvForPlayer(playerID);
                        PersonalInventory fake = new PersonalInventory(8);
                        fake.copy(inv, 8, 16);
                        if (this.canDoTrade(fluids, fake)) {
                            ActionResult result = trade.trade(playerID, this, sub, new TradeInventoryPlayer(inv, player), payload.getNumber(1));
                            if (result == null || result.func_188397_a() == EnumActionResult.FAIL) {
                                IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                                return;
                            }
                            if (result.func_188397_a() == EnumActionResult.PASS) {
                                IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                                return;
                            }
                            fake.clear();
                            fake.copy(inv, 8, 16);
                            ArrayList tradeFluids = new ArrayList((Collection)result.func_188398_b());
                            ArrayList<ItemStack> itemsToInject = new ArrayList<ItemStack>();
                            block0: for (FluidStack fluid : tradeFluids) {
                                FluidStack copy = fluid.copy();
                                boolean found = false;
                                for (int i = 0; i < fake.getSlotCount(); ++i) {
                                    ItemStack stack = fake.getStackInSlot(i);
                                    if (stack.func_190926_b()) continue;
                                    while (stack.func_190916_E() > 0) {
                                        ItemStack added = FluidHelper.fillContainer(stack, copy, true, false, true);
                                        if (added == null) continue;
                                        stack.func_190918_g(1);
                                        itemsToInject.add(added);
                                        if (copy.amount > 0) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue block0;
                                }
                            }
                            IItemTransporter trans = TransporterManager.manager.getTransporter(fake, true);
                            for (int i = 0; i < itemsToInject.size(); ++i) {
                                ItemStack added;
                                ItemStack use = ((ItemStack)itemsToInject.get(i)).func_77946_l();
                                if (use.func_190926_b() || (added = trans.addItem(use, EnumFacing.DOWN, true)).func_190926_b()) continue;
                                use.func_190918_g(added.func_190916_E());
                                if (player.field_71071_by.func_70441_a(use)) continue;
                                player.func_71019_a(use, true);
                            }
                            fake.inject(inv, 8, 16);
                        } else {
                            IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNoRoom);
                        }
                    } else {
                        IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                    }
                } else {
                    IC2.platform.messagePlayer(player, Ic2GuiLang.tradeNotPresent);
                }
            }
        }
    }

    public boolean canDoTrade(List<FluidStack> fluidList, IPersonalInventory inv) {
        for (FluidStack fluid : fluidList) {
            FluidStack copy = fluid.copy();
            boolean found = false;
            for (int i = 0; i < inv.getSlotCount(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                while (stack.func_190916_E() > 0) {
                    ItemStack added = FluidHelper.fillContainer(stack, copy, false, false, true);
                    if (added.func_190926_b()) continue;
                    stack.func_190918_g(1);
                    if (copy.amount > 0) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.state = value;
            this.getNetwork().updateTileGuiField(this, "state");
            if (player.field_71070_bA instanceof ContainerFluidOMatOpen) {
                ContainerFluidOMatOpen mat = (ContainerFluidOMatOpen)player.field_71070_bA;
                if (this.state == 0) {
                    mat.lock();
                    this.fab.clear();
                    this.currentSubTrade = 0;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                    this.display.clear();
                    this.fluidDisplay.clear();
                    this.getSyncer().markDirty(player);
                } else if (this.state == 1) {
                    mat.unlockAndUpdate();
                } else if (this.state == 2) {
                    mat.lock();
                    this.display.clear();
                    this.fluidDisplay.clear();
                }
            }
        } else if (event == 2) {
            this.removeSubTrade(player, value);
        } else if (event == 4) {
            if (value > 0) {
                this.fab.setItems(this.display, this.fluidDisplay, this.currentSubTrade);
                if (this.currentSubTrade < 3) {
                    ++this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                if (!this.fab.hasKey(this.currentSubTrade)) {
                    this.fab.setItems(this.currentSubTrade, this.display, this.fluidDisplay, value == 2 || value == 4, value == 3 || value == 4);
                }
                this.fab.pushToSlots(this.currentSubTrade, this.display, this.fluidDisplay);
            } else if (value < 0) {
                this.fab.setItems(this.display, this.fluidDisplay, this.currentSubTrade);
                if (this.currentSubTrade > 0) {
                    --this.currentSubTrade;
                    this.getNetwork().updateTileGuiField(this, "currentSubTrade");
                }
                this.fab.pushToSlots(this.currentSubTrade, this.display, this.fluidDisplay);
            }
        } else if (event == 5) {
            ItemTradeFabricator.ItemTradeRules rules = this.fab.getRules(this.currentSubTrade);
            if (value == 0) {
                rules.creative = !rules.creative;
            } else if (value == 1) {
                boolean bl = rules.money = !rules.money;
                if (player.field_71070_bA instanceof ContainerFluidOMatOpen) {
                    ContainerFluidOMatOpen mat = (ContainerFluidOMatOpen)player.field_71070_bA;
                    if (rules.money) {
                        mat.lockInput();
                        this.display.clear(0, 8);
                        this.fab.removeInput(this.currentSubTrade);
                        mat.func_75142_b();
                    } else {
                        mat.unlockInput();
                    }
                }
            } else if (value == 4) {
                rules.waitingAfterBuy = !rules.waitingAfterBuy;
            } else if (value == 5) {
                rules.tradeLimit = !rules.tradeLimit;
            } else if (value == 6) {
                rules.ignoreNBT = !rules.ignoreNBT;
            } else if (value == 7) {
                rules.useOreDictionary = !rules.useOreDictionary;
            }
        } else if (event == 6) {
            this.fab.getRules((int)this.currentSubTrade).moneyNeeded = value;
        } else if (event == 7) {
            this.fab.getRules((int)this.currentSubTrade).limitPerPlayer = value;
        } else if (event == 8) {
            this.fab.getRules((int)this.currentSubTrade).waitingTime = value;
        } else if (event == 10) {
            this.fab.setItems(this.display, this.fluidDisplay, this.currentSubTrade);
            this.addTrade(this.fab.createTrade(this.getOwner()));
            this.fab.clear();
            this.display.clear();
            this.fluidDisplay.clear();
            this.state = 0;
            this.currentSubTrade = 0;
            this.getNetwork().updateTileGuiField(this, "currentSubTrade");
            this.getNetwork().updateTileGuiField(this, "state");
            if (player.field_71070_bA instanceof ContainerFluidOMatOpen) {
                ((ContainerFluidOMatOpen)player.field_71070_bA).lock();
            }
        }
    }

    public boolean isOwner(EntityPlayer player) {
        return this.owner.equals(player.func_110124_au());
    }
}

