/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.entries;

import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.block.machine.recipes.entries.ScrapOutput;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public class ScrapMetalOutput
extends ScrapOutput {
    @Override
    public MachineOutput copy() {
        return new ScrapMetalOutput();
    }

    @Override
    public int getBaseChance() {
        return 4;
    }

    @Override
    public ItemStack getItem(Random rand) {
        return Ic2Items.scrapMetal.func_77946_l();
    }

    @Override
    public void onJEIInfo(BiConsumer<String, Vec3i> consumer) {
        super.onJEIInfo(consumer);
        consumer.accept(Ic2InfoLang.scrapboxChance.getLocalizedFormatted(Ic2Formatters.stackFormat.format(100.0 / (double)this.getBaseChance()) + "%"), belowOutputLeft);
    }

    public static class HighScrapMetalOutput
    extends ScrapMetalOutput {
        int min;
        int max;

        public HighScrapMetalOutput(int minValue, int maxValue) {
            this.min = minValue;
            this.max = maxValue;
        }

        @Override
        public MachineOutput copy() {
            return new HighScrapMetalOutput(this.min, this.max);
        }

        @Override
        public int getBaseChance() {
            return 2;
        }

        @Override
        public ItemStack getItem(Random rand) {
            return StackUtil.copyWithSize(Ic2Items.scrapMetal, MathHelper.func_76125_a((int)rand.nextInt(this.max + 1), (int)this.min, (int)this.max));
        }

        @Override
        public List<ItemStack> getAllOutputs() {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(StackUtil.copyWithSize(Ic2Items.scrapMetal, this.max));
            return list;
        }

        @Override
        public void onJEIInfo(BiConsumer<String, Vec3i> consumer) {
            super.onJEIInfo(consumer);
            consumer.accept(Ic2InfoLang.randomAmount.getLocalizedFormatted(this.min, this.max), aboveOutputLeft);
        }
    }
}

