/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.core.IC2;
import ic2.core.block.machine.med.logic.encoder.EncoderRegistry;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.util.helpers.ItemWithMeta;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.util.NonNullList;

public class PlannerRegistry {
    static Map<ItemWithMeta, ComponentStat> itemToStats = new HashMap<ItemWithMeta, ComponentStat>();
    static Map<ItemWithMeta, Short> itemToId = new HashMap<ItemWithMeta, Short>();
    static NonNullList<ItemStack> idToItem = NonNullList.func_191197_a((int)Short.MAX_VALUE, (Object)ItemStack.field_190927_a);
    static ItemStack[] reactorComponents = new ItemStack[0];
    static ItemStack[] steamReactorComponents = new ItemStack[0];
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToID = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToIDNormal = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static EnumMap<IReactorPlannerComponent.ReactorComponentType, List<Short>> typeToIDSteam = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    static EnumMap<IReactorPlannerComponent.ReactorComponentStat, LocaleComp> statToLocale = new EnumMap(IReactorPlannerComponent.ReactorComponentStat.class);
    static IReactorPlannerComponent.ReactorComponentType[] idToType = new IReactorPlannerComponent.ReactorComponentType[Short.MAX_VALUE];
    static ComponentSorter sorter = new ComponentSorter();

    public static void init() {
        ArrayList<ItemStack> reactor = new ArrayList<ItemStack>();
        ArrayList<ItemStack> steamReactor = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IReactorPlannerComponent)) continue;
            IReactorPlannerComponent component = (IReactorPlannerComponent)item;
            List<ItemStack> items = ComponentStat.createComponents(component);
            for (ItemStack stack : items) {
                List<Short> ids;
                short id = component.getID(stack);
                if (!((ItemStack)idToItem.get((int)id)).func_190926_b()) {
                    IC2.platform.displayError("ReactorPlanner ID is already used: " + id + ", Item Tried to be added: " + stack.func_82833_r() + ", Item that was added: " + ((ItemStack)idToItem.get((int)id)).func_82833_r());
                    return;
                }
                ItemStack copy = StackUtil.copyWithSize(stack, 1);
                ItemWithMeta meta = new ItemWithMeta(stack);
                itemToId.put(meta, id);
                idToItem.set((int)id, (Object)copy);
                IReactorPlannerComponent.ReactorType type = component.getReactorInfo(stack);
                IReactorPlannerComponent.ReactorComponentType compType = component.getType(stack);
                if (type.isReactor()) {
                    reactor.add(copy);
                    ids = typeToIDNormal.get((Object)compType);
                    if (ids == null) {
                        ids = new ArrayList<Short>();
                        typeToIDNormal.put(compType, ids);
                    }
                    ids.add(id);
                }
                if (type.isSteamReactor() && component instanceof ISteamReactorComponent) {
                    steamReactor.add(copy);
                    ids = typeToIDSteam.get((Object)compType);
                    if (ids == null) {
                        ids = new ArrayList<Short>();
                        typeToIDSteam.put(compType, ids);
                    }
                    ids.add(id);
                }
                PlannerRegistry.idToType[id] = compType;
                ids = typeToID.get((Object)compType);
                if (ids == null) {
                    ids = new ArrayList<Short>();
                    typeToID.put(compType, ids);
                }
                ids.add(id);
            }
        }
        Collections.sort(reactor, sorter);
        Collections.sort(steamReactor, sorter);
        reactorComponents = reactor.toArray(new ItemStack[reactor.size()]);
        steamReactorComponents = steamReactor.toArray(new ItemStack[steamReactor.size()]);
        EncoderRegistry.instance.init();
        for (IReactorPlannerComponent.ReactorComponentStat stat : IReactorPlannerComponent.ReactorComponentStat.values()) {
            statToLocale.put(stat, new LangComponentHolder.LocaleGuiComp("container.reactorStat" + stat.name() + ".name"));
        }
    }

    public static short getID(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        Short meta = itemToId.get(new ItemWithMeta(stack));
        if (meta == null) {
            return -1;
        }
        return meta;
    }

    public static IReactorPlannerComponent.ReactorComponentType getTypeByItem(ItemStack stack) {
        short id = PlannerRegistry.getID(stack);
        if (id == -1) {
            return null;
        }
        return idToType[id];
    }

    public static ItemStack[] getItemsByType(byte sorting, boolean steam) {
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (sorting == -1 || sorting >= array.length) {
            return PlannerRegistry.getItemsByType(null, steam);
        }
        return PlannerRegistry.getItemsByType(array[sorting], steam);
    }

    public static ItemStack[] getItemsByType(IReactorPlannerComponent.ReactorComponentType type, boolean steam) {
        if (type == null) {
            return steam ? steamReactorComponents : reactorComponents;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        List<Short> entries = (steam ? typeToIDSteam : typeToIDNormal).get((Object)type);
        if (entries == null || entries.isEmpty()) {
            return new ItemStack[0];
        }
        for (Short entry : entries) {
            ItemStack item = (ItemStack)idToItem.get((int)entry.shortValue());
            if (item.func_190926_b()) continue;
            list.add(item);
        }
        Collections.sort(list, sorter);
        return list.toArray(new ItemStack[list.size()]);
    }

    public static ItemStack getComponentFromID(short id) {
        if (id < 0 || id > idToItem.size()) {
            return ItemStack.field_190927_a;
        }
        return ((ItemStack)idToItem.get((int)id)).func_77946_l();
    }

    public static ComponentStat getStatsFromItem(ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        return itemToStats.get(new ItemWithMeta(item));
    }

    public static class ComponentSorter
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack par1, ItemStack par2) {
            short firstID = PlannerRegistry.getID(par1);
            short secID = PlannerRegistry.getID(par2);
            IReactorPlannerComponent.ReactorComponentType first = idToType[firstID];
            IReactorPlannerComponent.ReactorComponentType second = idToType[secID];
            if (first == null && second == null) {
                return 0;
            }
            if (first == null) {
                return 1;
            }
            if (second == null) {
                return -1;
            }
            if (first.ordinal() < second.ordinal()) {
                return -1;
            }
            if (first.ordinal() > second.ordinal()) {
                return 1;
            }
            if (firstID < secID) {
                return -1;
            }
            if (secID < firstID) {
                return 1;
            }
            return 0;
        }
    }

    public static class ComponentStat {
        EnumMap<IReactorPlannerComponent.ReactorComponentStat, NBTPrimitive> stats = new EnumMap(IReactorPlannerComponent.ReactorComponentStat.class);

        public ComponentStat(IReactorPlannerComponent planner, ItemStack stack) {
            IReactorPlannerComponent.ReactorComponentType type = planner.getType(stack);
            for (IReactorPlannerComponent.ReactorComponentStat stat : type.getStats()) {
                this.stats.put(stat, planner.getReactorStat(stat, stack));
            }
            List<IReactorPlannerComponent.ReactorComponentStat> list = planner.getExtraStats(stack);
            if (list != null) {
                for (IReactorPlannerComponent.ReactorComponentStat stat : list) {
                    this.stats.put(stat, planner.getReactorStat(stat, stack));
                }
            }
        }

        public static List<ItemStack> createComponents(IReactorPlannerComponent comp) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            if (comp.hasSubParts()) {
                list.addAll(Arrays.asList(comp.getSubParts()));
            } else {
                list.add(comp.getReactorPart());
            }
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                if (stack.func_190926_b()) {
                    list.remove(i--);
                    continue;
                }
                itemToStats.put(new ItemWithMeta(stack), new ComponentStat(comp, stack));
            }
            return list;
        }

        public Set<IReactorPlannerComponent.ReactorComponentStat> getKeys() {
            return this.stats.keySet();
        }

        public String getComponentText(IReactorPlannerComponent.ReactorComponentStat stat) {
            NBTPrimitive nbt = this.stats.get((Object)stat);
            LocaleComp comp = statToLocale.get((Object)stat);
            if (nbt.func_74732_a() == 5) {
                float value = nbt.func_150288_h();
                if (stat == IReactorPlannerComponent.ReactorComponentStat.ReactorEEM && value > 0.0f && value < 1.0f) {
                    return comp.getLocalizedFormatted((int)(value * 100.0f) + "%");
                }
                return comp.getLocalizedFormatted(Ic2Formatters.stackFormat.format(nbt.func_150288_h()));
            }
            return comp.getLocalizedFormatted(nbt.func_150287_d());
        }
    }
}

