/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.low.container.ContainerPump;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class TileEntityPump
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
IEnergyUser,
IPumpTile,
IBitLevelOverride {
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8, override=true)
    public int pumpCharge = 0;
    public int delay = 0;
    public int ticker = 0;
    FluidStack cache;

    public TileEntityPump() {
        this(32);
    }

    public TileEntityPump(int maxInput) {
        super(2, maxInput);
        this.maxEnergy = 200;
        this.setFuelSlot(1);
        this.addGuiFields("pumpCharge");
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.DOWN.invert());
        handler.registerDefaultSideAccess(AccessRule.None, RotationList.DOWN);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0);
        handler.registerDefaultSlotAccess(AccessRule.Both, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 0);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 1);
        handler.registerInputFilter(CommonFilters.FluidFilter, 0);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 1);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 1);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Discharge, 1);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit8;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("pumpCharge", this.pumpCharge);
        if (this.cache != null) {
            nbt.func_74782_a("cache", (NBTBase)this.cache.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.pumpCharge = nbt.func_74762_e("pumpCharge");
        this.cache = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("cache"));
    }

    @Override
    public float getProgress() {
        return this.pumpCharge;
    }

    @Override
    public float getMaxProgress() {
        return this.getMaxPumpCharge();
    }

    @Override
    public int getPumpCharge() {
        return this.pumpCharge;
    }

    @Override
    public int getMaxPumpCharge() {
        return 200;
    }

    public int getPumpDelay() {
        return 120;
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        int usage = this.getEnergyUsage();
        if (this.energy >= usage && !this.isPumpReady()) {
            this.useEnergy(usage);
            ++this.pumpCharge;
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
        }
        if (this.delay > 0) {
            --this.delay;
        }
        this.handleChargeSlot(this.maxEnergy);
        if (this.delay <= 0 && this.isPumpReady()) {
            Pumpkind kind = this.canPump();
            if (kind == null || kind == Pumpkind.None) {
                this.delay = this.getPumpDelay() / 2;
                return;
            }
            if (this.pump(kind)) {
                this.delay = this.getPumpDelay();
                this.getNetwork().updateTileGuiField(this, "pumpCharge");
            }
        }
        this.emptyCache();
        if (this.getActive() == this.isPumpReady() && this.energy > 0) {
            this.setActive(!this.getActive());
        }
        this.updateComparators();
    }

    public void emptyCache() {
        if (this.cache == null || this.cache.amount <= 0) {
            return;
        }
        for (Direction dir : Direction.directions) {
            IFluidHandler handler;
            if (dir == Direction.YN || (handler = FluidHelper.getFluidHandler(dir.applyToTileEntity(this), dir.getInverse().toFacing())) == null) continue;
            this.cache.amount -= handler.fill(this.cache, true);
            if (this.cache.amount > 0) continue;
            this.cache = null;
            return;
        }
    }

    public boolean pump(Pumpkind kind) {
        ItemStack stack;
        if (kind == null || kind == Pumpkind.None) {
            return false;
        }
        FluidStack fluid = this.getFluidBelow(true);
        if (fluid == null) {
            return false;
        }
        if (kind == Pumpkind.Tank) {
            int pumped = 0;
            for (Direction dir : Direction.directions) {
                IFluidHandler handler;
                if (dir == Direction.YN || (handler = FluidHelper.getFluidHandler(dir.applyToTileEntity(this), dir.getInverse().toFacing())) == null) continue;
                int toMove = handler.fill(fluid, true);
                fluid.amount -= toMove;
                pumped += toMove;
                if (fluid.amount > 0) continue;
                this.pumpCharge = 0;
                this.getNetwork().updateTileGuiField(this, "pumpCharge");
                return true;
            }
            if (pumped > 0 && fluid.amount > 0) {
                this.cache = fluid;
                this.pumpCharge = 0;
                this.getNetwork().updateTileGuiField(this, "pumpCharge");
                return true;
            }
        }
        if (kind == Pumpkind.Item && !(stack = this.fillIntoItem((ItemStack)this.inventory.get(0), fluid, true)).func_190926_b()) {
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            if (!this.sendItemAway(stack, true)) {
                StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), stack);
            }
            this.pumpCharge = 0;
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public EnumActionResult pumpThis(FluidStack fluid, boolean doFill) {
        if (fluid == null) {
            return EnumActionResult.FAIL;
        }
        if (this.cache != null) {
            return EnumActionResult.PASS;
        }
        FluidStack copy = fluid.copy();
        ItemStack stack = this.fillIntoItem((ItemStack)this.inventory.get(0), copy, doFill);
        if (!stack.func_190926_b()) {
            if (!this.isPumpReady()) {
                return EnumActionResult.PASS;
            }
            if (!doFill) {
                return EnumActionResult.SUCCESS;
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            this.pumpCharge = 0;
            this.delay = this.getPumpDelay();
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
            if (this.sendItemAway(stack, true)) {
                return EnumActionResult.SUCCESS;
            }
            StackUtil.dropAsEntity(this.func_145831_w(), this.func_174877_v(), stack);
            return EnumActionResult.SUCCESS;
        }
        if (!this.isPumpReady()) {
            void var8_12;
            int pumped = 0;
            Direction[] directionArray = Direction.directions;
            int n = directionArray.length;
            boolean bl = false;
            while (var8_12 < n) {
                IFluidHandler handler;
                Direction dir = directionArray[var8_12];
                if (dir != Direction.YN && (handler = FluidHelper.getFluidHandler(dir.applyToTileEntity(this), dir.getInverse().toFacing())) != null) {
                    int toMove = handler.fill(copy, false);
                    copy.amount -= toMove;
                    pumped += toMove;
                    if (copy.amount <= 0) {
                        return EnumActionResult.PASS;
                    }
                }
                ++var8_12;
            }
            if (pumped > 0 && copy.amount > 0) {
                return EnumActionResult.PASS;
            }
            return EnumActionResult.FAIL;
        }
        LinkedHashMap<IFluidHandler, Integer> amount = new LinkedHashMap<IFluidHandler, Integer>();
        int pumped = 0;
        for (Direction dir : Direction.directions) {
            int added;
            IFluidHandler handler;
            if (dir == Direction.YN || (handler = FluidHelper.getFluidHandler(dir.applyToTileEntity(this), dir.getInverse().toFacing())) == null || (added = handler.fill(copy, false)) <= 0) continue;
            amount.put(handler, added);
            copy.amount -= added;
            pumped += added;
            if (copy.amount <= 0) break;
        }
        for (Map.Entry entry : amount.entrySet()) {
            ((IFluidHandler)entry.getKey()).fill(FluidHelper.copyWithSize(fluid, (Integer)entry.getValue()), doFill);
        }
        if (doFill) {
            this.pumpCharge = 0;
            this.delay = this.getPumpDelay();
            this.getNetwork().updateTileGuiField(this, "pumpCharge");
            if (copy.amount > 0) {
                this.cache = copy;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean sendItemAway(ItemStack stack, boolean doRemove) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Direction dir : Direction.directions) {
            ItemStack result;
            IItemTransporter trans;
            TileEntity tile = dir.applyToTileEntity(this);
            if (tile == null || tile instanceof TileEntityMiner || tile instanceof TileEntityPump || (trans = TransporterManager.manager.getTransporter(tile, true)) == null || (result = trans.addItem(stack, dir.toFacing().func_176734_d(), doRemove)).func_190926_b()) continue;
            stack.func_190918_g(result.func_190916_E());
            if (!stack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean isFluidBlockBelow() {
        return this.getFluidBelow(false) != null;
    }

    public boolean isFluidBelow(Fluid fluid) {
        FluidStack stack = this.getFluidBelow(false);
        return stack != null && stack.getFluid() == fluid;
    }

    public FluidStack getFluidBelow(boolean drain) {
        BlockPos target = this.field_174879_c.func_177977_b();
        if (this.field_145850_b.func_175623_d(target)) {
            return null;
        }
        IBlockState state = this.field_145850_b.func_180495_p(target);
        if (state.func_177230_c() instanceof IFluidBlock) {
            return ((IFluidBlock)state.func_177230_c()).drain(this.func_145831_w(), target, drain);
        }
        if (state.func_177230_c() instanceof BlockStaticLiquid) {
            Material mat = state.func_185904_a();
            if (mat != Material.field_151586_h && mat != Material.field_151587_i) {
                return null;
            }
            if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
                return null;
            }
            if (drain && (mat == Material.field_151586_h || !TileEntityPump.isNetherLava())) {
                this.field_145850_b.func_175698_g(target);
            }
            return new FluidStack(mat == Material.field_151586_h ? FluidRegistry.WATER : FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public Pumpkind canPump() {
        if (!this.isPumpReady() || this.cache != null) {
            return Pumpkind.None;
        }
        FluidStack fluid = this.getFluidBelow(false);
        if (fluid == null) {
            return Pumpkind.None;
        }
        if (this.canFillIntoItem((ItemStack)this.inventory.get(0), fluid) && this.sendItemAway(((ItemStack)this.inventory.get(0)).func_77946_l(), false)) {
            return Pumpkind.Item;
        }
        int added = 0;
        for (Direction dir : Direction.directions) {
            IFluidHandler handler;
            if (dir == Direction.YN || (handler = FluidHelper.getFluidHandler(dir.applyToTileEntity(this), dir.getInverse().toFacing())) == null || (added += handler.fill(fluid, false)) < fluid.amount) continue;
            return Pumpkind.Tank;
        }
        if (added > 0 && fluid.amount > 0) {
            return Pumpkind.Tank;
        }
        return Pumpkind.None;
    }

    public boolean canFillIntoItem(ItemStack stack, FluidStack fluid) {
        return FluidHelper.canFillContainer(stack, fluid, false);
    }

    public ItemStack fillIntoItem(ItemStack stack, FluidStack fluid, boolean doFill) {
        if (stack.func_190926_b() || fluid == null) {
            return ItemStack.field_190927_a;
        }
        return FluidHelper.fillContainer(stack, fluid, true, false, false);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= this.getMaxPumpCharge();
    }

    public static boolean isNetherLava() {
        return IC2.config.getFlag("NetherLava");
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerPump(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.pump;
    }

    public void usePump() {
        this.pumpCharge = 0;
        this.getNetwork().updateTileGuiField(this, "pumpCharge");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)EmptyFluidHandler.INSTANCE;
        }
        return super.getCapability(capability, facing);
    }

    public static enum Pumpkind {
        None,
        Item,
        Tank;

    }
}

