/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.tile.MachineType;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.obj.IFurnace;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;

public class TileEntityElectricFurnace
extends TileEntityBasicElectricMachine
implements IFurnace {
    public TileEntityElectricFurnace() {
        super(3, 3, 130, 32);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.furnace;
    }

    @Override
    public MachineType getType() {
        return MachineType.furnace;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.FurnaceGui.class;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.electricFurnace;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.electricFurnace;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return ClassicRecipes.furnace.getRecipeInAndOutput(input, false);
    }

    @Override
    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.electricFurnaceLoop;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (ClassicRecipes.furnace.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    public static void init() {
        TileEntityElectricFurnace.addRecipe(Ic2Items.tinOre.func_77946_l(), Ic2Items.tinIngot.func_77946_l(), 0.5f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.copperOre.func_77946_l(), Ic2Items.copperIngot.func_77946_l(), 0.5f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.silverOre.func_77946_l(), Ic2Items.silverIngot.func_77946_l(), 0.5f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.ironDust.func_77946_l(), new ItemStack(Items.field_151042_j, 1), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.goldDust.func_77946_l(), new ItemStack(Items.field_151043_k, 1), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.bronzeDust.func_77946_l(), Ic2Items.bronzeIngot.func_77946_l(), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.tinDust.func_77946_l(), Ic2Items.tinIngot.func_77946_l(), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.copperDust.func_77946_l(), Ic2Items.copperIngot.func_77946_l(), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.silverDust.func_77946_l(), Ic2Items.silverIngot.func_77946_l(), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.hydratedCoalDust.func_77946_l(), Ic2Items.coalDust.func_77946_l(), 0.0f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.hydratedCharCoalDust.func_77946_l(), Ic2Items.charcoalDust.func_77946_l(), 0.0f);
        TileEntityElectricFurnace.addRecipe(new ItemStack(Items.field_151042_j), Ic2Items.refinedIronIngot.func_77946_l(), 0.2f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.rubberWood.func_77946_l(), new ItemStack(Blocks.field_150364_r, 1, 3), 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.stickyResin.func_77946_l(), Ic2Items.rubber.func_77946_l(), 0.3f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.coldCoffee.func_77946_l(), Ic2Items.darkCoffee.func_77946_l());
        TileEntityElectricFurnace.addRecipe(Ic2Items.coldTea.func_77946_l(), Ic2Items.blackTea, 0.1f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.flour.func_77946_l(), new ItemStack(Items.field_151025_P), 0.35f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.bioChunk.func_77946_l(), Ic2Items.coalChunk.func_77946_l(), 0.3f);
        TileEntityElectricFurnace.addRecipe(Ic2Items.bioRawFiber.func_77946_l(), Ic2Items.carbonFiber.func_77946_l());
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, 0.0f);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        FurnaceRecipes.func_77602_a().func_151394_a(input, output, exp);
    }
}

