/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.info.Info;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.math.Box2D;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class TileEntityGenerator
extends TileEntityFuelGeneratorBase {
    @NetworkField(index=7)
    public int itemFuelValue;

    public TileEntityGenerator() {
        super(2);
        this.maxStorage = 4000;
        this.production = IC2.config.getInt("energyGeneratorBase");
        this.addGuiFields("itemFuelValue");
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 0);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 1);
        handler.registerInputFilter(CommonFilters.IronFurnaceFuelWithLava, 1);
        handler.registerOutputFilter(CommonFilters.NotIronFurnaceFuelWithLava, 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.Fuel, 1);
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.generatorFuelBox;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.generator;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.generator;
    }

    @Override
    public float getMaxFuel() {
        return this.itemFuelValue;
    }

    @Override
    public boolean gainFuel() {
        ItemStack stack = (ItemStack)this.inventory.get(1);
        if (stack.func_190926_b()) {
            return false;
        }
        int value = Info.itemInfo.getFuelValue(stack, true) / 4;
        if (value <= 0) {
            return false;
        }
        this.fuel += value;
        this.itemFuelValue = this.fuel;
        this.getNetwork().updateTileGuiField(this, "itemFuelValue");
        if (stack.func_77973_b().hasContainerItem(stack)) {
            this.inventory.set(1, (Object)stack.func_77973_b().getContainerItem(stack));
        } else {
            stack.func_190918_g(1);
        }
        return true;
    }

    @Override
    public boolean isConverting() {
        return this.fuel > 0;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return Ic2Sounds.generatorLoop;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.itemFuelValue = nbt.func_74762_e("LastItemFuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("LastItemFuel", this.itemFuelValue);
        return nbt;
    }
}

