/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.misc;

import ic2.api.classic.crops.ICropProvider;
import ic2.core.IC2;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class CropDifficulty {
    int level = IC2.config.getInt("CropDifficulty");

    public int getWeedChance() {
        switch (this.level) {
            case 0: {
                return 25;
            }
            case 1: {
                return 50;
            }
            case 3: {
                return 200;
            }
        }
        return 100;
    }

    public int getCropGrowth(int value) {
        switch (this.level) {
            case 0: {
                return value * 2;
            }
            case 1: {
                return (int)((double)value * 1.3);
            }
            case 3: {
                if (value == 0) {
                    return 0;
                }
                return (int)Math.max(1.0, (double)value * 0.75);
            }
        }
        return value;
    }

    public int getBreedingDifficulty() {
        switch (this.level) {
            case 0: {
                return 10;
            }
            case 1: {
                return 6;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    public byte[] getCropStats(List<ICropProvider> crops) {
        byte[] result = new byte[3];
        int size = crops.size();
        for (int k = 0; k < size; ++k) {
            result[0] = (byte)(result[0] + crops.get(k).getStatGrowth());
            result[1] = (byte)(result[1] + crops.get(k).getStatResistance());
            result[2] = (byte)(result[2] + crops.get(k).getStatGain());
        }
        for (int i = 0; i < result.length; ++i) {
            byte value = result[i];
            value = (byte)(value / size);
            value = (byte)(value + this.getRandomBoost(IC2.random, size));
            result[i] = (byte)MathHelper.func_76125_a((int)value, (int)0, (int)31);
        }
        return result;
    }

    private int getRandomBoost(Random rand, int count) {
        switch (this.level) {
            case 0: {
                return rand.nextInt(1 + 2 * count);
            }
            case 1: {
                return rand.nextInt(1 + 2 * count) - count / 2;
            }
            case 3: {
                int value = rand.nextInt(1 + 2 * count) - count;
                if (rand.nextBoolean()) {
                    return 0;
                }
                return value;
            }
        }
        return rand.nextInt(1 + 2 * count) - count;
    }
}

