/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropMelon
extends CropSeedDropBase {
    public CropMelon() {
        super(new CropProperties(2, 0, 4, 0, 2, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 4) {
            return this.getSprite("bc")[20];
        }
        return this.getSprite("bc")[15 + state];
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Green", "Food", "Stem"};
    }

    @Override
    public String getId() {
        return "Melon";
    }

    @Override
    public String getDiscoveredBy() {
        return "Chao";
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        return cropTile.getCurrentSize() <= 3;
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return (int)((float)humidity * 1.1f + (float)nutrients * 0.9f + (float)air);
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 4;
    }

    @Override
    public int getMaxSize() {
        return 4;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (IC2.random.nextInt(3) == 0) {
            return new ItemStack(Blocks.field_150440_ba);
        }
        return new ItemStack(Items.field_151127_ba, IC2.random.nextInt(4) + 2);
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_151081_bc);
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        if (crop.getStatGain() <= 1 && crop.getStatGrowth() <= 1 && crop.getStatResistance() <= 1) {
            return new ItemStack(Items.field_151081_bc, IC2.random.nextInt(2) + 1);
        }
        return super.getSeeds(crop);
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        if (cropTile.getCurrentSize() == 3) {
            return 700;
        }
        return 250;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 3;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 4;
    }
}

