/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.api.classic.tile.machine.ISpeedMachine;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class SpeedInfo
implements IProbeComponent {
    ISpeedMachine tile;

    public SpeedInfo(ISpeedMachine machine) {
        this.tile = machine;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        return Ic2InfoLang.machineSpeed.getLocalizedFormatted(Float.valueOf(this.tile.getSpeed()), Float.valueOf(this.tile.getMaxSpeed()));
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasEUReader();
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.MachineProgress;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasEUReader();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        info.progress((int)this.tile.getSpeed(), (int)this.tile.getMaxSpeed(), info.defaultProgressStyle().prefix("Speed: "));
    }
}

