/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.mj.IMjConnector", modid="buildcraftlib")})
public abstract class TileEntityRFProducer
extends TileEntityBlock
implements IEnergySink,
IEnergyStorage,
ITickable,
IMjConnector {
    public int maxEnergy;
    @NetworkField(index=3)
    public int energy;
    public int inputTier;
    public int maxInput;
    int delay = 0;
    TileEntity cacheTile;
    int config;
    boolean enet;

    public TileEntityRFProducer(int max, int tier) {
        this.maxEnergy = max;
        this.inputTier = tier;
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(tier);
        this.config = IC2.config.getInt("RFPerEU");
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public void func_73660_a() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.energy > 0) {
            if (this.cacheTile == null) {
                this.cacheTile = Direction.fromEnumFacing(this.getFacing()).applyToTileEntity(this);
            }
            if (this.cacheTile == null) {
                this.delay = 2000;
                return;
            }
            if (this.cacheTile.func_145837_r()) {
                this.cacheTile = null;
                return;
            }
            if (this.cacheTile.hasCapability(CapabilityEnergy.ENERGY, this.getFacing().func_176734_d())) {
                IEnergyStorage storage = (IEnergyStorage)this.cacheTile.getCapability(CapabilityEnergy.ENERGY, this.getFacing().func_176734_d());
                if (storage.canReceive()) {
                    int needed = storage.getMaxEnergyStored() - storage.getEnergyStored();
                    if (needed > 0) {
                        this.energy -= storage.receiveEnergy(Math.min(this.energy, needed), false);
                        this.getNetwork().updateTileGuiField(this, "energy");
                    } else {
                        this.delay = 50;
                    }
                } else {
                    this.delay = 50;
                }
            } else if (!Loader.isModLoaded((String)"buildcraftlib") || !this.handleBC(this.cacheTile)) {
                this.delay = 2000;
            }
        }
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean handleBC(TileEntity tile) {
        if (tile.hasCapability(MjAPI.CAP_RECEIVER, this.getFacing().func_176734_d())) {
            IMjReceiver receiver = (IMjReceiver)this.cacheTile.getCapability(MjAPI.CAP_RECEIVER, this.getFacing().func_176734_d());
            if (receiver.canReceive() && receiver.canConnect((IMjConnector)this)) {
                int toTransfer = (int)Math.min(receiver.getPowerRequested() / MjAPI.ONE_MINECRAFT_JOULE, (long)(this.energy / 10));
                if (toTransfer > 0) {
                    this.energy = (int)((double)this.energy - ((double)toTransfer - (double)(receiver.receivePower((long)toTransfer * MjAPI.ONE_MINECRAFT_JOULE, false) / MjAPI.ONE_MINECRAFT_JOULE) * 10.0));
                    this.getNetwork().updateTileGuiField(this, "energy");
                } else {
                    this.delay = 50;
                }
            } else {
                this.delay = 50;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockUpdate(Block block) {
        this.cacheTile = null;
        this.delay = 0;
    }

    @Override
    public void setFacing(EnumFacing face) {
        if (this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.enet = false;
        super.setFacing(face);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.enet = true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating() && !this.enet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.enet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.enet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.enet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return side != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return (this.maxEnergy - this.energy) / this.config;
    }

    @Override
    public int getSinkTier() {
        return this.inputTier;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount > (double)this.maxInput || amount <= 0.0) {
            return 0.0;
        }
        this.energy = (int)((double)this.energy + amount * (double)this.config);
        int left = 0;
        if (this.energy >= this.maxEnergy) {
            left = (this.energy - this.maxEnergy) / this.config;
            this.energy = this.maxEnergy;
        }
        this.getNetwork().updateTileGuiField(this, "energy");
        return left;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > this.energy) {
            maxExtract = this.energy;
        }
        if (!simulate) {
            this.energy -= maxExtract;
        }
        return maxExtract;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return facing == null || facing == this.getFacing();
        }
        if (Loader.isModLoaded((String)"buildcraftlib") && this.isMJ(capability)) {
            return facing == null || facing == this.getFacing();
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        if (Loader.isModLoaded((String)"buildcraftlib") && this.isMJ(capability)) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return facing != this.getFacing();
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean isMJ(Capability<?> cap) {
        return MjAPI.CAP_CONNECTOR == cap;
    }

    @Optional.Method(modid="buildcraftlib")
    public boolean canConnect(IMjConnector arg0) {
        if (arg0 instanceof IMjReceiver) {
            return ((IMjReceiver)arg0).canReceive();
        }
        return false;
    }
}

