/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.event;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;

@Cancelable
public class RetextureEventClassic
extends WorldEvent {
    private final BlockPos targetPos;
    private final EnumFacing targetSide;
    private final EntityPlayer applingPlayer;
    private final EnumFacing refSide;
    private final IBlockState modelState;
    private final IBlockState renderState;
    private final int[] colorMultipliers;
    private final Rotation[] textureRotations;
    boolean isApplied;

    public RetextureEventClassic(World world, BlockPos pos, EnumFacing dir, EntityPlayer player, EnumFacing side, IBlockState model, IBlockState render, int[] colors, Rotation[] rotations) {
        super(world);
        if (world == null || world.field_72995_K || pos == null || dir == null || side == null || model == null || render == null || colors == null || rotations == null || colors.length != rotations.length) {
            this.setCanceled(true);
        }
        this.targetPos = pos;
        this.targetSide = dir;
        this.applingPlayer = player;
        this.refSide = side;
        this.modelState = model;
        this.renderState = render;
        this.colorMultipliers = colors;
        this.textureRotations = rotations;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public IBlockState getTargetState() {
        return this.getWorld().func_180495_p(this.targetPos);
    }

    public TileEntity getTargetTile() {
        return this.getWorld().func_175625_s(this.getTargetPos());
    }

    public EnumFacing getTargetSide() {
        return this.targetSide;
    }

    public EntityPlayer getApplingPlayer() {
        return this.applingPlayer;
    }

    public EnumFacing getRefSide() {
        return this.refSide;
    }

    public IBlockState getModelState() {
        return this.modelState;
    }

    public IBlockState getRenderState() {
        return this.renderState;
    }

    public int[] getColorMultipliers() {
        return this.colorMultipliers;
    }

    public Rotation[] getRotations() {
        return this.textureRotations;
    }

    public boolean isApplied() {
        return this.isApplied;
    }

    public void setApplied(boolean apply) {
        this.isApplied = apply;
    }

    public static enum Rotation {
        Rotation0(0),
        Rotation90(90),
        Rotation180(180),
        Rotation270(270);

        int rotation;

        private Rotation(int facing) {
            this.rotation = facing;
        }

        public int getRotation() {
            return this.rotation;
        }

        public static Rotation getRotation(byte index) {
            Rotation[] values = Rotation.values();
            if (values.length > index) {
                return values[index];
            }
            return values[0];
        }

        public static Rotation[] convert(byte[] array) {
            Rotation[] result = new Rotation[array.length];
            Rotation[] values = Rotation.values();
            for (int i = 0; i < array.length; ++i) {
                result[i] = values[array[i]];
            }
            return result;
        }

        public static byte[] invertConverting(Rotation[] array) {
            byte[] result = new byte[array.length];
            for (int i = 0; i < array.length; ++i) {
                result[i] = (byte)array[i].ordinal();
            }
            return result;
        }
    }
}

