/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.preprocessor;

import crafttweaker.preprocessor.PreprocessorActionBase;
import crafttweaker.runtime.ScriptFile;

public class PriorityPreprocessor
extends PreprocessorActionBase {
    private static final String PREPROCESSOR_NAME = "priority";
    private Integer priority;

    public PriorityPreprocessor(String fileName, String preprocessorLine, int lineIndex) {
        super(fileName, preprocessorLine, lineIndex);
        String s = preprocessorLine.substring(9).trim();
        try {
            this.priority = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.priority = null;
        }
    }

    @Override
    public void executeActionOnFind(ScriptFile scriptFile) {
        if (this.priority != null) {
            scriptFile.setPriority(this.priority);
        }
    }

    @Override
    public String getPreprocessorName() {
        return PREPROCESSOR_NAME;
    }
}

