/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.recipes;

import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.recipes.ICraftingInventory;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;

public class MCCraftingInventorySquared
implements ICraftingInventory {
    private final IInventory inventory;
    private final IPlayer player;
    private final int height;
    private final int width;

    protected MCCraftingInventorySquared(IInventory inventory) {
        this(inventory, null);
    }

    public MCCraftingInventorySquared(IInventory inventory, IPlayer player) {
        this.inventory = inventory;
        this.height = this.width = (int)Math.sqrt(inventory.func_70302_i_());
        this.player = player == null ? MCCraftingInventorySquared.getPlayerFromInventory(inventory) : player;
    }

    private static IPlayer getPlayerFromInventory(IInventory inventory) {
        if (inventory instanceof InventoryCrafting) {
            InventoryCrafting inventoryCrafting = (InventoryCrafting)inventory;
            Container eventHandler = inventoryCrafting.field_70465_c;
            if (eventHandler != null) {
                for (Slot slot : eventHandler.field_75151_b) {
                    if (!(slot instanceof SlotCrafting)) continue;
                    return CraftTweakerMC.getIPlayer(((SlotCrafting)slot).field_75238_b);
                }
            }
        }
        return null;
    }

    public static MCCraftingInventorySquared get(IInventory inventory) {
        return new MCCraftingInventorySquared(inventory);
    }

    @Override
    public IPlayer getPlayer() {
        return this.player;
    }

    @Override
    public int getSize() {
        return this.inventory.func_70302_i_();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStackCount() {
        int count = 0;
        for (int slot = 0; slot < this.getSize(); ++slot) {
            if (this.inventory.func_70301_a(slot).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public IItemStack getStack(int i) {
        return CraftTweakerMC.getIItemStack(this.inventory.func_70301_a(i));
    }

    @Override
    public IItemStack getStack(int row, int column) {
        return this.getStack(column + row * this.getWidth());
    }

    @Override
    public void setStack(int row, int column, IItemStack stack) {
        this.setStack(column + row * this.getWidth(), stack);
    }

    @Override
    public void setStack(int i, IItemStack stack) {
        this.inventory.func_70299_a(i, CraftTweakerMC.getItemStack(stack));
    }

    @Override
    public IItemStack[][] getItems() {
        IItemStack[][] output = new IItemStack[this.getHeight()][this.getWidth()];
        IItemStack[] oneDimensional = this.getItemArray();
        for (int row = 0; row < this.getHeight(); ++row) {
            for (int column = 0; column < this.getWidth(); ++column) {
                output[row][column] = oneDimensional[row * this.getWidth() + column];
            }
        }
        return output;
    }

    @Override
    public IItemStack[] getItemArray() {
        IItemStack[] output = new IItemStack[this.getSize()];
        for (int slot = 0; slot < this.getSize(); ++slot) {
            output[slot] = CraftTweakerMC.getIItemStack(this.inventory.func_70301_a(slot));
        }
        return output;
    }

    @Override
    public Object getInternal() {
        return this.inventory;
    }
}

