/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.VertexAttribute;
import java.util.ArrayList;
import java.util.Collections;

public class CCRenderPipeline {
    private CCRenderState renderState;
    public boolean forceFormatAttributes = true;
    private ArrayList<VertexAttribute> attribs = new ArrayList();
    private ArrayList<IVertexOperation> ops = new ArrayList();
    private ArrayList<PipelineNode> nodes = new ArrayList();
    private ArrayList<IVertexOperation> sorted = new ArrayList();
    private PipelineNode loading;
    private PipelineBuilder builder;

    public CCRenderPipeline(CCRenderState renderState) {
        this.renderState = renderState;
        this.builder = new PipelineBuilder(renderState);
    }

    public void setPipeline(IVertexOperation ... ops) {
        this.ops.clear();
        Collections.addAll(this.ops, ops);
        this.rebuild();
    }

    public void reset() {
        this.ops.clear();
        this.unbuild();
    }

    private void unbuild() {
        for (VertexAttribute attrib : this.attribs) {
            attrib.active = false;
        }
        this.attribs.clear();
        this.sorted.clear();
    }

    public void rebuild() {
        if (this.forceFormatAttributes) {
            if (this.renderState.fmt.func_177350_b()) {
                this.addAttribute(this.renderState.normalAttrib);
            }
            if (this.renderState.fmt.func_177346_d()) {
                this.addAttribute(this.renderState.colourAttrib);
            }
            if (this.renderState.computeLighting) {
                this.addAttribute(this.renderState.lightingAttrib);
            }
        }
        if (this.ops.isEmpty() || this.renderState.model == null) {
            return;
        }
        while (this.nodes.size() < CCRenderState.operationCount()) {
            this.nodes.add(new PipelineNode());
        }
        this.unbuild();
        for (int i = 0; i < this.ops.size(); ++i) {
            IVertexOperation op = this.ops.get(i);
            this.loading = this.nodes.get(op.operationID());
            boolean loaded = op.load(this.renderState);
            if (loaded) {
                this.loading.op = op;
            }
            if (!(op instanceof VertexAttribute)) continue;
            if (loaded) {
                this.attribs.add((VertexAttribute)op);
                continue;
            }
            ((VertexAttribute)op).active = false;
        }
        for (PipelineNode node : this.nodes) {
            node.add();
        }
    }

    public void addRequirement(int opRef) {
        this.loading.deps.add(this.nodes.get(opRef));
    }

    public void addDependency(VertexAttribute attrib) {
        this.loading.deps.add(this.nodes.get(attrib.operationID()));
        this.addAttribute(attrib);
    }

    public void addAttribute(VertexAttribute attrib) {
        if (!attrib.active) {
            this.ops.add(attrib);
            attrib.active = true;
        }
    }

    public void operate() {
        for (IVertexOperation aSorted : this.sorted) {
            aSorted.operate(this.renderState);
        }
    }

    public PipelineBuilder builder() {
        this.ops.clear();
        return this.builder;
    }

    private class PipelineNode {
        public ArrayList<PipelineNode> deps = new ArrayList();
        public IVertexOperation op;

        private PipelineNode() {
        }

        public void add() {
            if (this.op == null) {
                return;
            }
            for (PipelineNode dep : this.deps) {
                dep.add();
            }
            this.deps.clear();
            CCRenderPipeline.this.sorted.add(this.op);
            this.op = null;
        }
    }

    public class PipelineBuilder {
        CCRenderState renderState;

        public PipelineBuilder(CCRenderState renderState) {
            this.renderState = renderState;
        }

        public PipelineBuilder add(IVertexOperation op) {
            CCRenderPipeline.this.ops.add(op);
            return this;
        }

        public PipelineBuilder add(IVertexOperation ... ops) {
            Collections.addAll(CCRenderPipeline.this.ops, ops);
            return this;
        }

        public void build() {
            CCRenderPipeline.this.rebuild();
        }

        public void render() {
            CCRenderPipeline.this.rebuild();
            this.renderState.render();
        }
    }
}

