/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.block.property.unlisted.UnlistedPropertyBase;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class ModelErrorStateProperty
extends UnlistedPropertyBase<ErrorState> {
    public static final ModelErrorStateProperty ERROR_STATE = new ModelErrorStateProperty();

    private ModelErrorStateProperty() {
        super("ccl_model_error_state");
    }

    public Class<ErrorState> getType() {
        return ErrorState.class;
    }

    public String valueToString(ErrorState value) {
        return value.toString();
    }

    public static class ErrorState {
        public static final ErrorState OK = new ErrorState(false);
        private final boolean errored;
        private String reason = "OK";

        public ErrorState(boolean errored) {
            this.errored = errored;
        }

        public ErrorState setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public ErrorState setReason(Throwable e) {
            return this.setReason(ExceptionUtils.getStackTrace((Throwable)e));
        }

        public boolean hasErrored() {
            return this.errored;
        }

        public String getReason() {
            return this.reason;
        }

        public static ErrorState of(String string) {
            return new ErrorState(true).setReason(string);
        }

        public static ErrorState of(String string, Object ... data) {
            return ErrorState.of(String.format(string, data));
        }

        public static ErrorState of(Throwable e) {
            return new ErrorState(true).setReason(e);
        }

        public String toString() {
            if (this.hasErrored()) {
                return this.getReason();
            }
            return "No Error: OK";
        }
    }
}

