/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import team.chisel.ctm.api.util.NonnullType;
import team.chisel.ctm.client.util.CTMLogic;

@ParametersAreNonnullByDefault
public enum Dir {
    TOP(EnumFacing.UP),
    TOP_RIGHT(EnumFacing.UP, EnumFacing.EAST),
    RIGHT(EnumFacing.EAST),
    BOTTOM_RIGHT(EnumFacing.DOWN, EnumFacing.EAST),
    BOTTOM(EnumFacing.DOWN),
    BOTTOM_LEFT(EnumFacing.DOWN, EnumFacing.WEST),
    LEFT(EnumFacing.WEST),
    TOP_LEFT(EnumFacing.UP, EnumFacing.WEST);

    public static final Dir[] VALUES;
    private static final EnumFacing NORMAL;
    @NonnullType
    private EnumFacing[] dirs;
    @NonnullType
    private BlockPos[] offsets = new BlockPos[6];

    private Dir(EnumFacing ... dirs) {
        this.dirs = dirs;
    }

    private void buildCaches() {
        for (EnumFacing normal : EnumFacing.field_82609_l) {
            BlockPos ret;
            EnumFacing[] normalized;
            if (normal == NORMAL) {
                normalized = this.dirs;
            } else if (normal == NORMAL.func_176734_d()) {
                ret = new EnumFacing[this.dirs.length];
                for (int i = 0; i < ((EnumFacing[])ret).length; ++i) {
                    ret[i] = this.dirs[i].func_96559_d() != 0 ? this.dirs[i] : this.dirs[i].func_176734_d();
                }
                normalized = ret;
            } else {
                EnumFacing axis = normal.func_96559_d() == 0 ? (normal == NORMAL.func_176746_e() ? EnumFacing.UP : EnumFacing.DOWN) : (normal == EnumFacing.UP ? NORMAL.func_176735_f() : NORMAL.func_176746_e());
                EnumFacing[] ret2 = new EnumFacing[this.dirs.length];
                for (int i = 0; i < ret2.length; ++i) {
                    ret2[i] = this.rotate(this.dirs[i], axis);
                }
                normalized = ret2;
            }
            ret = BlockPos.field_177992_a;
            for (EnumFacing dir : normalized) {
                ret = ret.func_177972_a(dir);
            }
            this.offsets[normal.ordinal()] = ret;
        }
    }

    public boolean isConnected(CTMLogic ctm, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return ctm.isConnected(world, pos, this.applyConnection(pos, side), side);
    }

    public boolean isConnected(CTMLogic ctm, IBlockAccess world, BlockPos pos, EnumFacing side, IBlockState state) {
        return ctm.isConnected(world, pos, this.applyConnection(pos, side), side, state);
    }

    @Nonnull
    public BlockPos applyConnection(BlockPos pos, EnumFacing side) {
        return pos.func_177971_a((Vec3i)this.getOffset(side));
    }

    public Dir relativize(EnumFacing normal) {
        throw new UnsupportedOperationException("Yell at tterrag to finish deserialization");
    }

    @Nonnull
    public BlockPos getOffset(EnumFacing normal) {
        return this.offsets[normal.ordinal()];
    }

    @Nullable
    public Dir getDirFor(EnumFacing[] dirs) {
        if (dirs == this.dirs) {
            return this;
        }
        for (Dir dir : VALUES) {
            if (!Arrays.equals(dir.dirs, dirs)) continue;
            return dir;
        }
        return null;
    }

    private EnumFacing rotate(EnumFacing facing, EnumFacing axisFacing) {
        EnumFacing.Axis axis = axisFacing.func_176740_k();
        EnumFacing.AxisDirection axisDir = axisFacing.func_176743_c();
        if (axisDir == EnumFacing.AxisDirection.POSITIVE) {
            return facing.func_176732_a(axis);
        }
        if (facing.func_176740_k() != axis) {
            switch (axis) {
                case X: {
                    switch (facing) {
                        case NORTH: {
                            return EnumFacing.UP;
                        }
                        case DOWN: {
                            return EnumFacing.NORTH;
                        }
                        case SOUTH: {
                            return EnumFacing.DOWN;
                        }
                        case UP: {
                            return EnumFacing.SOUTH;
                        }
                    }
                    return facing;
                }
                case Y: {
                    return facing.func_176735_f();
                }
                case Z: {
                    switch (facing) {
                        case EAST: {
                            return EnumFacing.EAST;
                        }
                        case WEST: {
                            return EnumFacing.WEST;
                        }
                        case UP: {
                            return EnumFacing.DOWN;
                        }
                        case DOWN: {
                            return EnumFacing.UP;
                        }
                    }
                    return facing;
                }
            }
        }
        return facing;
    }

    static {
        VALUES = Dir.values();
        NORMAL = EnumFacing.SOUTH;
        for (Dir dir : VALUES) {
            dir.buildCaches();
        }
    }
}

